/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.jeiplugin;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MintScreen;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.crafting.CoinMintRecipe;
import io.github.lightman314.lightmanscurrency.integration.jeiplugin.LCJeiPlugin;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CoinMintCategory
implements IRecipeCategory<CoinMintRecipe> {
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public CoinMintCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(MintScreen.GUI_TEXTURE, 55, 16, 82, 26);
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)ModBlocks.COIN_MINT.get()));
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            @Nonnull
            public IDrawableAnimated load(@Nonnull Integer mintTime) {
                return guiHelper.drawableBuilder(MintScreen.GUI_TEXTURE, 176, 0, 22, 16).buildAnimated(mintTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    protected IDrawableAnimated getArrow(CoinMintRecipe recipe) {
        int mintTime = recipe.getDuration();
        if (mintTime <= 0) {
            mintTime = 100;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)mintTime);
    }

    @NotNull
    public RecipeType<CoinMintRecipe> getRecipeType() {
        return LCJeiPlugin.COIN_MINT_TYPE;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(@Nonnull CoinMintRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull PoseStack pose, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, pose, mouseX, mouseY);
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(pose, 25, 5);
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public Class<? extends CoinMintRecipe> getRecipeClass() {
        return CoinMintRecipe.class;
    }

    @NotNull
    public Component getTitle() {
        return new TranslatableComponent("gui.lightmanscurrency.coinmint.title");
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CoinMintRecipe recipe, @NotNull IFocusGroup focus) {
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 1, 5);
        inputSlot.addIngredients(VanillaTypes.ITEM, (List)Lists.newArrayList((Object[])CoinMintCategory.SetStackCount(recipe.getIngredient().m_43908_(), recipe.ingredientCount)));
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 5);
        outputSlot.addIngredient(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    private static ItemStack[] SetStackCount(ItemStack[] results, int count) {
        for (ItemStack stack : results) {
            stack.m_41764_(count);
        }
        return results;
    }

    @NotNull
    public ResourceLocation getUid() {
        return LCJeiPlugin.COIN_MINT_UID;
    }
}

