/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.mixin;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MerchantMenu.class})
public abstract class MerchantMenuMixin {
    @Unique
    protected MerchantMenu self() {
        return (MerchantMenu)this;
    }

    @Accessor(value="trader")
    public abstract Merchant getTrader();

    @Accessor(value="tradeContainer")
    public abstract MerchantContainer getTradeContainer();

    public Player getPlayer() {
        Merchant m = this.getTrader();
        if (m != null) {
            return m.m_7962_();
        }
        return null;
    }

    @Inject(at={@At(value="HEAD")}, method={"tryMoveItems"})
    private void tryMoveItemsEarly(int trade, CallbackInfo info) {
        try {
            MerchantMenu self = this.self();
            if (trade >= 0 && trade < self.m_40075_().size()) {
                this.EjectMoneyIntoWallet(this.getPlayer(), false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tryMoveItems"})
    private void tryMoveItems(int trade, CallbackInfo info) {
        try {
            MerchantOffer offer;
            MerchantContainer tradeContainer;
            MerchantMenu self = this.self();
            if (trade >= 0 && trade < self.m_40075_().size() && (tradeContainer = this.getTradeContainer()).m_8020_(0).m_41619_() && tradeContainer.m_8020_(1).m_41619_() && MoneyUtil.isCoin((offer = (MerchantOffer)self.m_40075_().get(trade)).m_45358_(), false) && MerchantMenuMixin.isCoinOrEmpty(offer.m_45364_())) {
                ItemStack coinA = offer.m_45358_();
                ItemStack coinB = offer.m_45364_();
                CoinValue tradeValue = MoneyUtil.getCoinValue((List<ItemStack>)ImmutableList.of((Object)coinA, (Object)coinB));
                LightmansCurrency.LogDebug("Coin Value of the selected trade is " + tradeValue.getString());
                Player player = this.getPlayer();
                CoinValue availableFunds = WalletCapability.getWalletMoney((Entity)player);
                CoinValue fundsToExtract = CoinValue.EMPTY;
                int coinACount = coinA.m_41613_();
                int coinBCount = coinB.m_41619_() ? 0 : coinB.m_41613_();
                int coinAMaxCount = coinA.m_41741_();
                int coinBMaxCount = coinB.m_41619_() ? 0 : coinB.m_41741_();
                int coinToAddA = 0;
                int coinToAddB = 0;
                boolean keepLooping = true;
                while (keepLooping) {
                    int tempC2AA = coinAMaxCount > coinToAddA ? MathUtil.clamp(coinToAddA + coinACount, 0, coinAMaxCount) : coinToAddA;
                    int tempC2AB = coinBMaxCount > coinToAddB ? MathUtil.clamp(coinToAddB + coinBCount, 0, coinBMaxCount) : coinToAddB;
                    coinA.m_41764_(tempC2AA);
                    coinB.m_41764_(tempC2AB);
                    CoinValue thisValue = MoneyUtil.getCoinValue((List<ItemStack>)ImmutableList.of((Object)coinA, (Object)coinB));
                    if (availableFunds.getValueNumber() < thisValue.getValueNumber()) {
                        keepLooping = false;
                        continue;
                    }
                    fundsToExtract = thisValue;
                    coinToAddA = tempC2AA;
                    coinToAddB = tempC2AB;
                    if (coinToAddA < coinAMaxCount || coinToAddB < coinBMaxCount) continue;
                    keepLooping = false;
                }
                if ((coinToAddA > 0 || coinToAddB > 0) && fundsToExtract.hasAny()) {
                    coinA.m_41764_(coinToAddA);
                    coinB.m_41764_(coinToAddB);
                    if (MoneyUtil.ProcessPayment(null, player, fundsToExtract)) {
                        tradeContainer.m_6836_(0, coinA.m_41777_());
                        tradeContainer.m_6836_(1, coinB.m_41777_());
                        LightmansCurrency.LogDebug("Moved " + fundsToExtract.getString() + " worth of coins into the Merchant Menu!");
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"removed"})
    private void removed(Player player, CallbackInfo info) {
        if (this.isPlayerAliveAndValid(player)) {
            this.EjectMoneyIntoWallet(player, true);
        }
    }

    protected boolean isPlayerAliveAndValid(Player player) {
        if (player.m_6084_()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                return !sp.m_9232_();
            }
            return true;
        }
        return false;
    }

    private void EjectMoneyIntoWallet(Player player, boolean noUpdate) {
        MerchantContainer tradeContainer = this.getTradeContainer();
        ItemStack item = tradeContainer.m_8020_(0);
        if (!item.m_41619_() && MoneyUtil.isCoin(item, false)) {
            MoneyUtil.ProcessChange(null, player, MoneyUtil.getCoinValue(item));
            if (noUpdate) {
                tradeContainer.m_8016_(0);
            } else {
                tradeContainer.m_6836_(0, ItemStack.f_41583_);
            }
        }
        if (!(item = tradeContainer.m_8020_(1)).m_41619_() && MoneyUtil.isCoin(item, false)) {
            MoneyUtil.ProcessChange(null, player, MoneyUtil.getCoinValue(item));
            if (noUpdate) {
                tradeContainer.m_8016_(1);
            } else {
                tradeContainer.m_6836_(1, ItemStack.f_41583_);
            }
        }
    }

    private static boolean isCoinOrEmpty(ItemStack item) {
        return MoneyUtil.isCoin(item, false) || item.m_41619_();
    }
}

