/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network;

import io.github.lightman314.lightmanscurrency.common.atm.ATMData;
import io.github.lightman314.lightmanscurrency.common.money.MoneyData;
import io.github.lightman314.lightmanscurrency.network.message.CPacketRequestNBT;
import io.github.lightman314.lightmanscurrency.network.message.auction.CPacketSubmitBid;
import io.github.lightman314.lightmanscurrency.network.message.auction.SPacketStartBid;
import io.github.lightman314.lightmanscurrency.network.message.auction.SPacketSyncAuctionStandDisplay;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketATMSetPlayerAccount;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketBankInteraction;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketBankTransferPlayer;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketBankTransferTeam;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketOpenATM;
import io.github.lightman314.lightmanscurrency.network.message.bank.CPacketSelectBankAccount;
import io.github.lightman314.lightmanscurrency.network.message.bank.SPacketATMPlayerAccountResponse;
import io.github.lightman314.lightmanscurrency.network.message.bank.SPacketBankTransferResponse;
import io.github.lightman314.lightmanscurrency.network.message.bank.SPacketInitializeClientBank;
import io.github.lightman314.lightmanscurrency.network.message.bank.SPacketSyncSelectedBankAccount;
import io.github.lightman314.lightmanscurrency.network.message.bank.SPacketUpdateClientBank;
import io.github.lightman314.lightmanscurrency.network.message.command.SPacketDebugTrader;
import io.github.lightman314.lightmanscurrency.network.message.command.SPacketSyncAdminList;
import io.github.lightman314.lightmanscurrency.network.message.data.SPacketClearClientTraders;
import io.github.lightman314.lightmanscurrency.network.message.data.SPacketMessageRemoveClientTrader;
import io.github.lightman314.lightmanscurrency.network.message.data.SPacketRemoveClientTeam;
import io.github.lightman314.lightmanscurrency.network.message.data.SPacketSyncNotifications;
import io.github.lightman314.lightmanscurrency.network.message.data.SPacketUpdateClientTeam;
import io.github.lightman314.lightmanscurrency.network.message.data.SPacketUpdateClientTrader;
import io.github.lightman314.lightmanscurrency.network.message.emergencyejection.CPacketOpenEjectionMenu;
import io.github.lightman314.lightmanscurrency.network.message.emergencyejection.SPacketSyncEjectionData;
import io.github.lightman314.lightmanscurrency.network.message.enchantments.SPacketMoneyMendingClink;
import io.github.lightman314.lightmanscurrency.network.message.interfacebe.CPacketInterfaceHandlerMessage;
import io.github.lightman314.lightmanscurrency.network.message.interfacebe.CPacketInterfaceInteraction;
import io.github.lightman314.lightmanscurrency.network.message.menu.CPacketLazyMenu;
import io.github.lightman314.lightmanscurrency.network.message.menu.SPacketLazyMenu;
import io.github.lightman314.lightmanscurrency.network.message.notifications.CPacketFlagNotificationsSeen;
import io.github.lightman314.lightmanscurrency.network.message.notifications.SPacketChatNotification;
import io.github.lightman314.lightmanscurrency.network.message.paygate.CPacketCollectTicketStubs;
import io.github.lightman314.lightmanscurrency.network.message.persistentdata.CPacketCreatePersistentAuction;
import io.github.lightman314.lightmanscurrency.network.message.persistentdata.CPacketCreatePersistentTrader;
import io.github.lightman314.lightmanscurrency.network.message.playertrading.CPacketPlayerTradeInteraction;
import io.github.lightman314.lightmanscurrency.network.message.playertrading.SPacketSyncPlayerTrade;
import io.github.lightman314.lightmanscurrency.network.message.tax.SPacketRemoveTax;
import io.github.lightman314.lightmanscurrency.network.message.tax.SPacketSyncClientTax;
import io.github.lightman314.lightmanscurrency.network.message.teams.CPacketCreateTeam;
import io.github.lightman314.lightmanscurrency.network.message.teams.CPacketEditTeam;
import io.github.lightman314.lightmanscurrency.network.message.teams.SPacketClearClientTeams;
import io.github.lightman314.lightmanscurrency.network.message.teams.SPacketCreateTeamResponse;
import io.github.lightman314.lightmanscurrency.network.message.time.SPacketSyncTime;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketAddOrRemoveTrade;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketCollectCoins;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketExecuteTrade;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenNetworkTerminal;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenStorage;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketOpenTrades;
import io.github.lightman314.lightmanscurrency.network.message.trader.CPacketStoreCoins;
import io.github.lightman314.lightmanscurrency.network.message.trader.SPacketSyncUsers;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketChestQuickCollect;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketOpenWallet;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketOpenWalletBank;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketWalletExchangeCoins;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketWalletQuickCollect;
import io.github.lightman314.lightmanscurrency.network.message.wallet.CPacketWalletToggleAutoExchange;
import io.github.lightman314.lightmanscurrency.network.message.wallet.SPacketPlayPickupSound;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.CPacketSetVisible;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.CPacketWalletInteraction;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.SPacketSyncWallet;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class LightmansCurrencyPacketHandler {
    public static final String PROTOCOL_VERSION = "1";
    public static SimpleChannel instance;
    private static int nextId;

    public static void init() {
        instance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("lightmanscurrency", "network")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).simpleChannel();
        LightmansCurrencyPacketHandler.register(CPacketOpenATM.class, CPacketOpenATM.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketSelectBankAccount.class, CPacketSelectBankAccount.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketBankInteraction.class, CPacketBankInteraction.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketInitializeClientBank.class, SPacketInitializeClientBank.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketUpdateClientBank.class, SPacketUpdateClientBank.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketBankTransferTeam.class, CPacketBankTransferTeam.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketBankTransferPlayer.class, CPacketBankTransferPlayer.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketBankTransferResponse.class, SPacketBankTransferResponse.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketATMSetPlayerAccount.class, CPacketATMSetPlayerAccount.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketATMPlayerAccountResponse.class, SPacketATMPlayerAccountResponse.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketSyncSelectedBankAccount.class, SPacketSyncSelectedBankAccount.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketExecuteTrade.class, CPacketExecuteTrade.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketCollectCoins.class, CPacketCollectCoins.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketStoreCoins.class, CPacketStoreCoins.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketOpenStorage.class, CPacketOpenStorage.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketOpenTrades.class, CPacketOpenTrades.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketOpenNetworkTerminal.class, CPacketOpenNetworkTerminal.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketSyncUsers.class, SPacketSyncUsers.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketAddOrRemoveTrade.class, CPacketAddOrRemoveTrade.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketCollectTicketStubs.class, CPacketCollectTicketStubs.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketPlayPickupSound.class, SPacketPlayPickupSound.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketWalletExchangeCoins.class, CPacketWalletExchangeCoins.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketWalletToggleAutoExchange.class, CPacketWalletToggleAutoExchange.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketOpenWallet.class, CPacketOpenWallet.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketOpenWalletBank.class, CPacketOpenWalletBank.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketWalletQuickCollect.class, CPacketWalletQuickCollect.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketChestQuickCollect.class, CPacketChestQuickCollect.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketSyncWallet.class, SPacketSyncWallet.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketSetVisible.class, CPacketSetVisible.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketWalletInteraction.class, CPacketWalletInteraction.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketClearClientTraders.class, SPacketClearClientTraders.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketUpdateClientTrader.class, SPacketUpdateClientTrader.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketMessageRemoveClientTrader.class, SPacketMessageRemoveClientTrader.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketStartBid.class, SPacketStartBid.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketSubmitBid.class, CPacketSubmitBid.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketSyncAuctionStandDisplay.class, SPacketSyncAuctionStandDisplay.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketInterfaceHandlerMessage.class, CPacketInterfaceHandlerMessage.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketInterfaceInteraction.class, CPacketInterfaceInteraction.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketClearClientTeams.class, SPacketClearClientTeams.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketRemoveClientTeam.class, SPacketRemoveClientTeam.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketUpdateClientTeam.class, SPacketUpdateClientTeam.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketEditTeam.class, CPacketEditTeam.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketCreateTeam.class, CPacketCreateTeam.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketCreateTeamResponse.class, SPacketCreateTeamResponse.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketLazyMenu.class, SPacketLazyMenu.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketLazyMenu.class, CPacketLazyMenu.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketSyncNotifications.class, SPacketSyncNotifications.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketFlagNotificationsSeen.class, CPacketFlagNotificationsSeen.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketChatNotification.class, SPacketChatNotification.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketSyncClientTax.class, SPacketSyncClientTax.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketRemoveTax.class, SPacketRemoveTax.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketRequestNBT.class, CPacketRequestNBT.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketSyncTime.class, SPacketSyncTime.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketSyncAdminList.class, SPacketSyncAdminList.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketDebugTrader.class, SPacketDebugTrader.HANDLER);
        LightmansCurrencyPacketHandler.register(MoneyData.class, MoneyData.PACKET_HANDLER);
        LightmansCurrencyPacketHandler.register(ATMData.class, ATMData.PACKET_HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketMoneyMendingClink.class, SPacketMoneyMendingClink.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketCreatePersistentTrader.class, CPacketCreatePersistentTrader.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketCreatePersistentAuction.class, CPacketCreatePersistentAuction.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketSyncEjectionData.class, SPacketSyncEjectionData.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketOpenEjectionMenu.class, CPacketOpenEjectionMenu.HANDLER);
        LightmansCurrencyPacketHandler.register(SPacketSyncPlayerTrade.class, SPacketSyncPlayerTrade.HANDLER);
        LightmansCurrencyPacketHandler.register(CPacketPlayerTradeInteraction.class, CPacketPlayerTradeInteraction.HANDLER);
    }

    private static <T extends CustomPacket> void register(@Nonnull Class<T> clazz, @Nonnull CustomPacket.Handler<T> handler) {
        instance.registerMessage(nextId++, clazz, CustomPacket::encode, handler::decode, handler::handlePacket);
    }

    public static PacketDistributor.PacketTarget getTarget(Player player) {
        if (player instanceof ServerPlayer) {
            return LightmansCurrencyPacketHandler.getTarget((ServerPlayer)player);
        }
        return null;
    }

    public static PacketDistributor.PacketTarget getTarget(ServerPlayer player) {
        return PacketDistributor.PLAYER.with(() -> player);
    }

    static {
        nextId = 0;
    }
}

