/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.auction;

import io.github.lightman314.lightmanscurrency.common.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class CPacketSubmitBid
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketSubmitBid> HANDLER = new H();
    final long auctionHouseID;
    final int tradeIndex;
    final CoinValue bidAmount;

    public CPacketSubmitBid(long auctionHouseID, int tradeIndex, CoinValue bidAmount) {
        this.auctionHouseID = auctionHouseID;
        this.tradeIndex = tradeIndex;
        this.bidAmount = bidAmount;
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeLong(this.auctionHouseID);
        buffer.writeInt(this.tradeIndex);
        this.bidAmount.encode(buffer);
    }

    private static class H
    extends CustomPacket.Handler<CPacketSubmitBid> {
        private H() {
        }

        @Override
        @Nonnull
        public CPacketSubmitBid decode(@Nonnull FriendlyByteBuf buffer) {
            return new CPacketSubmitBid(buffer.readLong(), buffer.readInt(), CoinValue.decode(buffer));
        }

        @Override
        protected void handle(@Nonnull CPacketSubmitBid message, @Nullable ServerPlayer sender) {
            AbstractContainerMenu abstractContainerMenu;
            if (sender != null && (abstractContainerMenu = sender.f_36096_) instanceof TraderMenu) {
                TraderMenu menu = (TraderMenu)abstractContainerMenu;
                TraderData data = TraderSaveData.GetTrader(false, message.auctionHouseID);
                if (data instanceof AuctionHouseTrader) {
                    AuctionHouseTrader ah = (AuctionHouseTrader)data;
                    ah.makeBid((Player)sender, menu, message.tradeIndex, message.bidAmount);
                }
            }
        }
    }
}

