/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.bank.interfaces.IBankAccountMenu;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CPacketBankInteraction
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketBankInteraction> HANDLER = new H();
    boolean isDeposit;
    CoinValue amount;

    public CPacketBankInteraction(boolean isDeposit, CoinValue amount) {
        this.isDeposit = isDeposit;
        this.amount = amount;
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isDeposit);
        this.amount.encode(buffer);
    }

    private static final class H
    extends CustomPacket.Handler<CPacketBankInteraction> {
        private H() {
        }

        @Override
        @Nonnull
        public CPacketBankInteraction decode(@Nonnull FriendlyByteBuf buffer) {
            return new CPacketBankInteraction(buffer.readBoolean(), CoinValue.decode(buffer));
        }

        @Override
        protected void handle(@Nonnull CPacketBankInteraction message, @Nullable ServerPlayer sender) {
            AbstractContainerMenu abstractContainerMenu;
            if (sender != null && (abstractContainerMenu = sender.f_36096_) instanceof IBankAccountMenu) {
                IBankAccountMenu menu = (IBankAccountMenu)abstractContainerMenu;
                if (message.isDeposit) {
                    BankAccount.DepositCoins(menu, message.amount);
                } else {
                    BankAccount.WithdrawCoins(menu, message.amount);
                }
                menu.onDepositOrWithdraw();
            }
        }
    }
}

