/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.bank.interfaces.IBankAccountAdvancedMenu;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.bank.reference.types.TeamBankReference;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.message.bank.SPacketBankTransferResponse;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CPacketBankTransferTeam
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketBankTransferTeam> HANDLER = new H();
    long teamID;
    CoinValue amount;

    public CPacketBankTransferTeam(long teamID, CoinValue amount) {
        this.teamID = teamID;
        this.amount = amount;
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeLong(this.teamID);
        this.amount.encode(buffer);
    }

    private static class H
    extends CustomPacket.Handler<CPacketBankTransferTeam> {
        private H() {
        }

        @Override
        @Nonnull
        public CPacketBankTransferTeam decode(@Nonnull FriendlyByteBuf buffer) {
            return new CPacketBankTransferTeam(buffer.readLong(), CoinValue.decode(buffer));
        }

        @Override
        protected void handle(@Nonnull CPacketBankTransferTeam message, @Nullable ServerPlayer sender) {
            BankReference destination;
            IBankAccountAdvancedMenu menu;
            MutableComponent response;
            AbstractContainerMenu abstractContainerMenu;
            if (sender != null && (abstractContainerMenu = sender.f_36096_) instanceof IBankAccountAdvancedMenu && (response = BankAccount.TransferCoins(menu = (IBankAccountAdvancedMenu)abstractContainerMenu, message.amount, destination = TeamBankReference.of(message.teamID))) != null) {
                new SPacketBankTransferResponse(response).sendTo(sender);
            }
        }
    }
}

