/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.persistentdata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class CPacketCreatePersistentAuction
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketCreatePersistentAuction> HANDLER = new H();
    private static final String GENERATE_ID_FORMAT = "auction_";
    final CompoundTag auctionData;
    final String id;

    public CPacketCreatePersistentAuction(CompoundTag auctionData, String id) {
        this.auctionData = auctionData;
        this.id = id;
    }

    private JsonObject getAuctionJson(String id) {
        AuctionTradeData auction = new AuctionTradeData(this.auctionData);
        JsonObject json = new JsonObject();
        json.addProperty("id", id);
        json = auction.saveToJson(json);
        return json;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.auctionData);
        buffer.m_130070_(this.id);
    }

    private static class H
    extends CustomPacket.Handler<CPacketCreatePersistentAuction> {
        private H() {
        }

        @Override
        @Nonnull
        public CPacketCreatePersistentAuction decode(@Nonnull FriendlyByteBuf buffer) {
            return new CPacketCreatePersistentAuction(buffer.m_130261_(), buffer.m_130277_());
        }

        @Override
        protected void handle(@Nonnull CPacketCreatePersistentAuction message, @Nullable ServerPlayer sender) {
            if (LCAdminMode.isAdminPlayer((Player)sender)) {
                int i;
                boolean generateID = message.id.isBlank();
                if (!generateID) {
                    JsonObject auctionJson = message.getAuctionJson(message.id);
                    JsonArray persistentAuctions = TraderSaveData.getPersistentTraderJson("Auctions");
                    for (int i2 = 0; i2 < persistentAuctions.size(); ++i2) {
                        JsonObject auctionData = persistentAuctions.get(i2).getAsJsonObject();
                        if (!auctionData.has("id") || !auctionData.get("id").getAsString().equals(message.id)) continue;
                        persistentAuctions.set(i2, (JsonElement)auctionJson);
                        TraderSaveData.setPersistentTraderSection("Auctions", persistentAuctions);
                        EasyText.sendMessage((Player)sender, (Component)EasyText.translatable("lightmanscurrency.message.persistent.auction.overwrite", message.id));
                        return;
                    }
                    persistentAuctions.add((JsonElement)auctionJson);
                    TraderSaveData.setPersistentTraderSection("Auctions", persistentAuctions);
                    EasyText.sendMessage((Player)sender, (Component)EasyText.translatable("lightmanscurrency.message.persistent.auction.add", message.id));
                    return;
                }
                ArrayList<String> knownIDs = new ArrayList<String>();
                JsonArray persistentAuctions = TraderSaveData.getPersistentTraderJson("Auctions");
                for (i = 0; i < persistentAuctions.size(); ++i) {
                    JsonObject auctionData = persistentAuctions.get(i).getAsJsonObject();
                    if (!auctionData.has("id")) continue;
                    knownIDs.add(auctionData.get("id").getAsString());
                }
                for (i = 1; i < Integer.MAX_VALUE; ++i) {
                    String genID = CPacketCreatePersistentAuction.GENERATE_ID_FORMAT + i;
                    if (!knownIDs.stream().noneMatch(id -> id.equals(genID))) continue;
                    persistentAuctions.add((JsonElement)message.getAuctionJson(genID));
                    TraderSaveData.setPersistentTraderSection("Auctions", persistentAuctions);
                    EasyText.sendMessage((Player)sender, (Component)EasyText.translatable("lightmanscurrency.message.persistent.auction.add", genID));
                    return;
                }
                LightmansCurrency.LogError("Could not generate ID, as all auction_# ID's are somehow spoken for.");
            } else if (sender != null) {
                EasyText.sendMessage((Player)sender, (Component)EasyText.translatable("lightmanscurrency.message.persistent.auction.fail", new Object[0]));
            }
        }
    }
}

