/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.persistentdata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class CPacketCreatePersistentTrader
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketCreatePersistentTrader> HANDLER = new H();
    private static final String GENERATE_ID_FORMAT = "trader_";
    final long traderID;
    final String id;
    final String owner;

    public CPacketCreatePersistentTrader(long traderID, String id, String owner) {
        this.traderID = traderID;
        this.id = id;
        this.owner = owner.isBlank() ? "Minecraft" : owner;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeLong(this.traderID);
        buffer.m_130070_(this.id);
        buffer.m_130070_(this.owner);
    }

    private static class H
    extends CustomPacket.Handler<CPacketCreatePersistentTrader> {
        private H() {
        }

        @Override
        @Nonnull
        public CPacketCreatePersistentTrader decode(@Nonnull FriendlyByteBuf buffer) {
            return new CPacketCreatePersistentTrader(buffer.readLong(), buffer.m_130277_(), buffer.m_130277_());
        }

        @Override
        protected void handle(@Nonnull CPacketCreatePersistentTrader message, @Nullable ServerPlayer sender) {
            if (LCAdminMode.isAdminPlayer((Player)sender)) {
                TraderData trader = TraderSaveData.GetTrader(false, message.traderID);
                if (trader != null && trader.canMakePersistent()) {
                    boolean generateID = message.id.isBlank();
                    if (!generateID) {
                        try {
                            JsonObject traderJson = trader.saveToJson(message.id, message.owner);
                            JsonArray persistentTraders = TraderSaveData.getPersistentTraderJson("Traders");
                            for (int i = 0; i < persistentTraders.size(); ++i) {
                                JsonObject traderData = persistentTraders.get(i).getAsJsonObject();
                                if ((!traderData.has("ID") || !traderData.get("ID").getAsString().equals(message.id)) && (!traderData.has("id") || !traderData.get("id").getAsString().equals(message.id))) continue;
                                persistentTraders.set(i, (JsonElement)traderJson);
                                TraderSaveData.setPersistentTraderSection("Traders", persistentTraders);
                                EasyText.sendMessage((Player)sender, (Component)EasyText.translatable("lightmanscurrency.message.persistent.trader.overwrite", message.id));
                                return;
                            }
                            persistentTraders.add((JsonElement)traderJson);
                            TraderSaveData.setPersistentTraderSection("Traders", persistentTraders);
                            EasyText.sendMessage((Player)sender, (Component)EasyText.translatable("lightmanscurrency.message.persistent.trader.add", message.id));
                            return;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    } else {
                        try {
                            int i;
                            ArrayList<String> knownIDs = new ArrayList<String>();
                            JsonArray persistentTraders = TraderSaveData.getPersistentTraderJson("Traders");
                            for (i = 0; i < persistentTraders.size(); ++i) {
                                JsonObject traderData = persistentTraders.get(i).getAsJsonObject();
                                if (traderData.has("id")) {
                                    knownIDs.add(traderData.get("id").getAsString());
                                }
                                if (!traderData.has("ID")) continue;
                                knownIDs.add(traderData.get("ID").getAsString());
                            }
                            for (i = 1; i < Integer.MAX_VALUE; ++i) {
                                String genID = CPacketCreatePersistentTrader.GENERATE_ID_FORMAT + i;
                                if (!knownIDs.stream().noneMatch(id -> id.equals(genID))) continue;
                                persistentTraders.add((JsonElement)trader.saveToJson(genID, message.owner));
                                TraderSaveData.setPersistentTraderSection("Traders", persistentTraders);
                                EasyText.sendMessage((Player)sender, (Component)EasyText.translatable("lightmanscurrency.message.persistent.trader.add", genID));
                                return;
                            }
                            LightmansCurrency.LogError("Could not generate ID, as all trader_# ID's are somehow spoken for.");
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            } else if (sender != null) {
                EasyText.sendMessage((Player)sender, (Component)EasyText.translatable("lightmanscurrency.message.persistent.trader.fail", new Object[0]));
            }
        }
    }
}

