/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.common.menus.validation.IValidatedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.network.packet.ClientToServerPacket;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class CPacketOpenStorage
extends ClientToServerPacket {
    public static final CustomPacket.Handler<CPacketOpenStorage> HANDLER = new H();
    private final long traderID;

    public CPacketOpenStorage(long traderID) {
        this.traderID = traderID;
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeLong(this.traderID);
    }

    private static class H
    extends CustomPacket.Handler<CPacketOpenStorage> {
        private H() {
        }

        @Override
        @Nonnull
        public CPacketOpenStorage decode(@Nonnull FriendlyByteBuf buffer) {
            return new CPacketOpenStorage(buffer.readLong());
        }

        @Override
        protected void handle(@Nonnull CPacketOpenStorage message, @Nullable ServerPlayer sender) {
            if (sender != null) {
                TraderData trader;
                MenuValidator validator = SimpleValidator.NULL;
                AbstractContainerMenu abstractContainerMenu = sender.f_36096_;
                if (abstractContainerMenu instanceof IValidatedMenu) {
                    IValidatedMenu tm = (IValidatedMenu)abstractContainerMenu;
                    validator = tm.getValidator();
                }
                if ((trader = TraderSaveData.GetTrader(false, message.traderID)) != null) {
                    trader.openStorageMenu((Player)sender, validator);
                }
            }
        }
    }
}

