/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.packet;

import com.google.common.collect.ImmutableMap;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public final class LazyPacketData {
    public static final byte TYPE_NULL = 0;
    public static final byte TYPE_BOOLEAN = 1;
    public static final byte TYPE_INT = 2;
    public static final byte TYPE_LONG = 3;
    public static final byte TYPE_FLOAT = 4;
    public static final byte TYPE_DOUBLE = 5;
    public static final byte TYPE_STRING = 6;
    public static final byte TYPE_TEXT = 64;
    public static final byte TYPE_NBT = 65;
    private final ImmutableMap<String, Data> dataMap;

    private LazyPacketData(Map<String, Data> data) {
        this.dataMap = ImmutableMap.copyOf(data);
    }

    @Nonnull
    private Data getData(String key) {
        return (Data)this.dataMap.getOrDefault((Object)key, (Object)Data.NULL);
    }

    public boolean contains(String key) {
        return this.dataMap.containsKey((Object)key);
    }

    public boolean contains(String key, byte type) {
        return this.contains(key) && this.getData((String)key).type == type;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Data d = this.getData(key);
        if (d.type == 1) {
            return (Boolean)d.value;
        }
        return defaultValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        Data d = this.getData(key);
        if (d.type == 2) {
            return (Integer)d.value;
        }
        return defaultValue;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        Data d = this.getData(key);
        if (d.type == 3) {
            return (Long)d.value;
        }
        return defaultValue;
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float defaultValue) {
        Data d = this.getData(key);
        if (d.type == 4) {
            return ((Float)d.value).floatValue();
        }
        return defaultValue;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        Data d = this.getData(key);
        if (d.type == 5) {
            return (Double)d.value;
        }
        return defaultValue;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        Data d = this.getData(key);
        if (d.type == 6) {
            return (String)d.value;
        }
        return defaultValue;
    }

    public Component getText(String key) {
        return this.getText(key, (Component)EasyText.empty());
    }

    public Component getText(String key, Component defaultValue) {
        Data d = this.getData(key);
        if (d.type == 64) {
            return (Component)d.value;
        }
        return defaultValue;
    }

    public CompoundTag getNBT(String key) {
        return this.getNBT(key, new CompoundTag());
    }

    public CompoundTag getNBT(String key, CompoundTag defaultValue) {
        Data d = this.getData(key);
        if (d.type == 65) {
            return (CompoundTag)d.value;
        }
        return defaultValue;
    }

    public CoinValue getCoinValue(String key) {
        return this.getCoinValue(key, CoinValue.EMPTY);
    }

    public CoinValue getCoinValue(String key, CoinValue defaultValue) {
        Data d = this.getData(key);
        if (d.type == 65) {
            return CoinValue.load((CompoundTag)d.value);
        }
        return defaultValue;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.dataMap.entrySet().size());
        this.dataMap.forEach((key, data) -> {
            buffer.m_130072_(key, 32);
            buffer.writeByte((int)data.type);
            data.encode(buffer);
        });
    }

    public static LazyPacketData decode(FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        HashMap<String, Data> dataMap = new HashMap<String, Data>();
        for (int i = 0; i < count; ++i) {
            String key = buffer.m_130136_(32);
            Data data = Data.decode(buffer);
            dataMap.put(key, data);
        }
        return new LazyPacketData(dataMap);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder simpleFlag(String key) {
        return LazyPacketData.simpleBoolean(key, true);
    }

    public static Builder simpleBoolean(String key, boolean value) {
        return LazyPacketData.builder().setBoolean(key, value);
    }

    public static Builder simpleInt(String key, int value) {
        return LazyPacketData.builder().setInt(key, value);
    }

    public static Builder simpleLong(String key, long value) {
        return LazyPacketData.builder().setLong(key, value);
    }

    public static Builder simpleFloat(String key, float value) {
        return LazyPacketData.builder().setFloat(key, value);
    }

    public static Builder simpleDouble(String key, double value) {
        return LazyPacketData.builder().setDouble(key, value);
    }

    public static Builder simpleString(String key, String value) {
        return LazyPacketData.builder().setString(key, value);
    }

    public static Builder simpleText(String key, Component value) {
        return LazyPacketData.builder().setText(key, value);
    }

    public static Builder simpleTag(String key, CompoundTag value) {
        return LazyPacketData.builder().setCompound(key, value);
    }

    public static Builder simpleCoinValue(String key, CoinValue value) {
        return LazyPacketData.builder().setCoinValue(key, value);
    }

    private record Data(byte type, Object value) {
        static final Data NULL = new Data(0, null);

        static Data ofNull() {
            return NULL;
        }

        static Data ofBoolean(boolean value) {
            return new Data(1, value);
        }

        static Data ofInt(int value) {
            return new Data(2, value);
        }

        static Data ofLong(long value) {
            return new Data(3, value);
        }

        static Data ofFloat(float value) {
            return new Data(4, Float.valueOf(value));
        }

        static Data ofDouble(double value) {
            return new Data(5, value);
        }

        static Data ofString(String value) {
            return value == null ? NULL : new Data(6, value);
        }

        static Data ofText(Component value) {
            return value == null ? NULL : new Data(64, value);
        }

        static Data ofNBT(CompoundTag value) {
            return value == null ? NULL : new Data(65, value);
        }

        static Data ofCoinValue(CoinValue value) {
            return value == null ? NULL : Data.ofNBT(value.save());
        }

        void encode(FriendlyByteBuf buffer) {
            if (this.type == 1) {
                buffer.writeBoolean(((Boolean)this.value).booleanValue());
            }
            if (this.type == 2) {
                buffer.writeInt(((Integer)this.value).intValue());
            }
            if (this.type == 3) {
                buffer.writeLong(((Long)this.value).longValue());
            }
            if (this.type == 4) {
                buffer.writeFloat(((Float)this.value).floatValue());
            }
            if (this.type == 5) {
                buffer.writeDouble(((Double)this.value).doubleValue());
            }
            if (this.type == 6) {
                buffer.m_130070_((String)this.value);
            }
            if (this.type == 64) {
                buffer.m_130070_(Component.Serializer.m_130703_((Component)((Component)this.value)));
            }
            if (this.type == 65) {
                buffer.m_130079_((CompoundTag)this.value);
            }
        }

        static Data decode(FriendlyByteBuf buffer) {
            byte type = buffer.readByte();
            if (type == 0) {
                return Data.ofNull();
            }
            if (type == 1) {
                return Data.ofBoolean(buffer.readBoolean());
            }
            if (type == 2) {
                return Data.ofInt(buffer.readInt());
            }
            if (type == 3) {
                return Data.ofLong(buffer.readLong());
            }
            if (type == 4) {
                return Data.ofFloat(buffer.readFloat());
            }
            if (type == 5) {
                return Data.ofDouble(buffer.readDouble());
            }
            if (type == 6) {
                return Data.ofString(buffer.m_130277_());
            }
            if (type == 64) {
                return Data.ofText((Component)Component.Serializer.m_130701_((String)buffer.m_130277_()));
            }
            if (type == 65) {
                return Data.ofNBT(buffer.m_130260_());
            }
            throw new RuntimeException("Could not decode entry of type " + type + "as it is not a valid data entry type!");
        }
    }

    public static final class Builder {
        Map<String, Data> data = new HashMap<String, Data>();

        private Builder() {
        }

        public Builder setBoolean(String key, boolean value) {
            this.data.put(key, Data.ofBoolean(value));
            return this;
        }

        public Builder setInt(String key, int value) {
            this.data.put(key, Data.ofInt(value));
            return this;
        }

        public Builder setLong(String key, long value) {
            this.data.put(key, Data.ofLong(value));
            return this;
        }

        public Builder setFloat(String key, float value) {
            this.data.put(key, Data.ofFloat(value));
            return this;
        }

        public Builder setDouble(String key, double value) {
            this.data.put(key, Data.ofDouble(value));
            return this;
        }

        public Builder setString(String key, String value) {
            this.data.put(key, Data.ofString(value));
            return this;
        }

        public Builder setText(String key, Component value) {
            this.data.put(key, Data.ofText(value));
            return this;
        }

        public Builder setCompound(String key, CompoundTag value) {
            this.data.put(key, Data.ofNBT(value));
            return this;
        }

        public Builder setCoinValue(String key, CoinValue value) {
            this.data.put(key, Data.ofCoinValue(value));
            return this;
        }

        public LazyPacketData build() {
            return new LazyPacketData(this.data);
        }
    }
}

