/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.packet;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public abstract class ServerToClientPacket
extends CustomPacket {
    public final void sendTo(@Nonnull Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.sendTo(sp);
        }
    }

    public final void sendTo(@Nonnull ServerPlayer player) {
        this.sendTo((List<ServerPlayer>)ImmutableList.of((Object)player));
    }

    public final void sendTo(@Nonnull List<ServerPlayer> players) {
        this.sendToTargets(players.stream().map(LightmansCurrencyPacketHandler::getTarget).toList());
    }

    public final void sendToAll() {
        this.sendToTarget(PacketDistributor.ALL.noArg());
    }

    public final void sendToTarget(@Nonnull PacketDistributor.PacketTarget target) {
        this.sendToTargets((List<PacketDistributor.PacketTarget>)ImmutableList.of((Object)target));
    }

    public final void sendToTargets(@Nonnull List<PacketDistributor.PacketTarget> targets) {
        for (PacketDistributor.PacketTarget target : targets) {
            LightmansCurrencyPacketHandler.instance.send(target, (Object)this);
        }
    }

    public static class Simple
    extends ServerToClientPacket {
        @Override
        public final void encode(@Nonnull FriendlyByteBuf buffer) {
        }
    }
}

