/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.proxy;

import com.google.common.base.Suppliers;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.ClientEvents;
import io.github.lightman314.lightmanscurrency.client.data.ClientBankData;
import io.github.lightman314.lightmanscurrency.client.data.ClientEjectionData;
import io.github.lightman314.lightmanscurrency.client.data.ClientNotificationData;
import io.github.lightman314.lightmanscurrency.client.data.ClientTaxData;
import io.github.lightman314.lightmanscurrency.client.data.ClientTeamData;
import io.github.lightman314.lightmanscurrency.client.data.ClientTraderData;
import io.github.lightman314.lightmanscurrency.client.gui.overlay.WalletDisplayOverlay;
import io.github.lightman314.lightmanscurrency.client.gui.screen.NetworkTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.NotificationScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.CoinChestScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.EjectionRecoveryScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MintScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.PlayerTradeScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.SlotMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TaxCollectorScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TicketMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletBankScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ItemEditWidget;
import io.github.lightman314.lightmanscurrency.client.renderer.LCItemRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.AuctionStandBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.BookTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.CoinChestRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.FreezerTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.SlotMachineBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.BookRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.renderers.EnchantedBookRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.book.renderers.NormalBookRenderer;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.events.NotificationEvent;
import io.github.lightman314.lightmanscurrency.common.items.CoinBlockItem;
import io.github.lightman314.lightmanscurrency.common.items.CoinItem;
import io.github.lightman314.lightmanscurrency.common.menus.PlayerTradeMenu;
import io.github.lightman314.lightmanscurrency.common.money.CoinData;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.playertrading.ClientPlayerTrade;
import io.github.lightman314.lightmanscurrency.integration.curios.client.LCCuriosClient;
import io.github.lightman314.lightmanscurrency.proxy.CommonProxy;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    boolean openTeamManager = false;
    boolean openNotifications = false;
    private long timeOffset = 0L;
    private final Supplier<CoinChestBlockEntity> coinChestBE = Suppliers.memoize(() -> new CoinChestBlockEntity(BlockPos.f_121853_, ((Block)ModBlocks.COIN_CHEST.get()).m_49966_()));

    @Override
    public void setupClient() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.DISPLAY_CASE.get()), (RenderType)RenderType.m_110463_());
        this.setRenderLayer(ModBlocks.VENDING_MACHINE.getAll(), RenderType.m_110463_());
        this.setRenderLayer(ModBlocks.VENDING_MACHINE_LARGE.getAll(), RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.ARMOR_DISPLAY.get()), (RenderType)RenderType.m_110463_());
        this.setRenderLayer(ModBlocks.AUCTION_STAND.getAll(), RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.GEM_TERMINAL.get()), (RenderType)RenderType.m_110466_());
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.ATM.get()), ATMScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.MINT.get()), MintScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.NETWORK_TERMINAL.get()), NetworkTerminalScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.TRADER.get()), TraderScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.TRADER_BLOCK.get()), TraderScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.TRADER_NETWORK_ALL.get()), TraderScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.TRADER_STORAGE.get()), TraderStorageScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.SLOT_MACHINE.get()), SlotMachineScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.WALLET.get()), WalletScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.WALLET_BANK.get()), WalletBankScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.TICKET_MACHINE.get()), TicketMachineScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.TRADER_INTERFACE.get()), TraderInterfaceScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.TRADER_RECOVERY.get()), EjectionRecoveryScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.PLAYER_TRADE.get()), PlayerTradeScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.COIN_CHEST.get()), CoinChestScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.TAX_COLLECTOR.get()), TaxCollectorScreen::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.ITEM_TRADER.get()), ItemTraderBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.FREEZER_TRADER.get()), FreezerTraderBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.SLOT_MACHINE_TRADER.get()), SlotMachineBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.BOOK_TRADER.get()), BookTraderBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.AUCTION_STAND.get()), AuctionStandBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.COIN_CHEST.get()), CoinChestRenderer::new);
        ClientRegistry.registerKeyBinding((KeyMapping)ClientEvents.KEY_WALLET);
        ClientRegistry.registerKeyBinding((KeyMapping)ClientEvents.KEY_PORTABLE_TERMINAL);
        ClientRegistry.registerKeyBinding((KeyMapping)ClientEvents.KEY_PORTABLE_ATM);
        ItemEditWidget.BlacklistCreativeTabs(CreativeModeTab.f_40760_, CreativeModeTab.f_40761_, CreativeModeTab.f_40754_);
        ItemEditWidget.BlacklistItem(ModItems.TICKET);
        ItemEditWidget.BlacklistItem(ModItems.TICKET_MASTER);
        ItemEditWidget.AddExtraItemAfter(new ItemStack((ItemLike)Items.f_42615_), Items.f_42614_);
        BookRenderer.register(NormalBookRenderer.GENERATOR);
        BookRenderer.register(EnchantedBookRenderer.GENERATOR);
        LCItemRenderer.registerBlockEntitySource(this::checkForCoinChest);
        OverlayRegistry.registerOverlayTop((String)"wallet_hud", (IIngameOverlay)WalletDisplayOverlay.INSTANCE);
        if (LightmansCurrency.isCuriosLoaded()) {
            LCCuriosClient.registerRenderLayers();
        }
    }

    private BlockEntity checkForCoinChest(Block block) {
        if (block == ModBlocks.COIN_CHEST.get()) {
            return this.coinChestBE.get();
        }
        return null;
    }

    private void setRenderLayer(List<Block> blocks, RenderType type) {
        for (Block b : blocks) {
            ItemBlockRenderTypes.setRenderLayer((Block)b, (RenderType)type);
        }
    }

    @Override
    public void clearClientTraders() {
        ClientTraderData.ClearTraders();
    }

    @Override
    public void updateTrader(CompoundTag compound) {
        ClientTraderData.UpdateTrader(compound);
    }

    @Override
    public void removeTrader(long traderID) {
        ClientTraderData.RemoveTrader(traderID);
    }

    @Override
    public void clearTeams() {
        ClientTeamData.ClearTeams();
    }

    @Override
    public void updateTeam(CompoundTag compound) {
        ClientTeamData.UpdateTeam(compound);
    }

    @Override
    public void removeTeam(long teamID) {
        ClientTeamData.RemoveTeam(teamID);
    }

    @Override
    public void initializeBankAccounts(CompoundTag compound) {
        if (compound.m_128425_("BankAccounts", 9)) {
            HashMap<UUID, BankAccount> bank = new HashMap<UUID, BankAccount>();
            ListTag bankList = compound.m_128437_("BankAccounts", 10);
            for (int i = 0; i < bankList.size(); ++i) {
                CompoundTag tag = bankList.m_128728_(i);
                UUID id = tag.m_128342_("Player");
                BankAccount bankAccount = new BankAccount(tag);
                bank.put(id, bankAccount);
            }
            ClientBankData.InitBankAccounts(bank);
        }
    }

    @Override
    public void updateBankAccount(CompoundTag compound) {
        ClientBankData.UpdateBankAccount(compound);
    }

    @Override
    public void receiveEmergencyEjectionData(CompoundTag compound) {
        ClientEjectionData.UpdateEjectionData(compound);
    }

    @Override
    public void updateNotifications(NotificationData data) {
        ClientNotificationData.UpdateNotifications(data);
    }

    @Override
    public void receiveNotification(Notification notification) {
        Minecraft mc = Minecraft.m_91087_();
        if (MinecraftForge.EVENT_BUS.post((Event)new NotificationEvent.NotificationReceivedOnClient(mc.f_91074_.m_142081_(), ClientNotificationData.GetNotifications(), notification))) {
            return;
        }
        if (((Boolean)Config.CLIENT.pushNotificationsToChat.get()).booleanValue()) {
            mc.f_91065_.m_93076_().m_93785_((Component)notification.getChatMessage());
        }
    }

    @Override
    public void receiveSelectedBankAccount(BankReference selectedAccount) {
        ClientBankData.UpdateLastSelectedAccount(selectedAccount);
    }

    @Override
    public void updateTaxEntries(CompoundTag compound) {
        ClientTaxData.UpdateEntry(compound);
    }

    @Override
    public void removeTaxEntry(long id) {
        ClientTaxData.RemoveEntry(id);
    }

    @Override
    public void openNotificationScreen() {
        this.openNotifications = true;
    }

    @Override
    public void openTeamManager() {
        this.openTeamManager = true;
    }

    @Override
    public void createTeamResponse(long teamID) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen instanceof TeamManagerScreen) {
            TeamManagerScreen screen2 = (TeamManagerScreen)screen;
            screen2.setActiveTeam(teamID);
        }
    }

    @Override
    public long getTimeDesync() {
        return this.timeOffset;
    }

    @Override
    public void setTimeDesync(long serverTime) {
        this.timeOffset = serverTime - System.currentTimeMillis();
        this.timeOffset = this.timeOffset / 1000L * 1000L;
        if (this.timeOffset < 10000L) {
            this.timeOffset = 0L;
        }
    }

    @Override
    public void loadAdminPlayers(List<UUID> serverAdminList) {
        LCAdminMode.loadAdminPlayers(serverAdminList);
    }

    @SubscribeEvent
    public void openScreenOnRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (this.openTeamManager) {
                this.openTeamManager = false;
                Minecraft.m_91087_().m_91152_((Screen)new TeamManagerScreen());
            } else if (this.openNotifications) {
                this.openNotifications = false;
                Minecraft.m_91087_().m_91152_((Screen)new NotificationScreen());
            }
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        Item item = event.getItemStack().m_41720_();
        CoinData coinData = MoneyUtil.getData(item);
        if (coinData != null && !(item instanceof CoinItem) && !(item instanceof CoinBlockItem)) {
            CoinItem.addCoinTooltips(event.getItemStack(), event.getToolTip());
        }
    }

    @Override
    public void playCoinSound() {
        if (((Boolean)Config.CLIENT.moneyMendingClink.get()).booleanValue()) {
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)ModSounds.COINS_CLINKING.get()), (float)1.0f, (float)0.4f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerLogin(ClientPlayerNetworkEvent.LoggedInEvent event) {
        ItemEditWidget.ConfirmItemListLoaded();
    }

    @Override
    @Nonnull
    public Level safeGetDummyLevel() throws Exception {
        Level level = this.getDummyLevelFromServer();
        if (level == null) {
            level = Minecraft.m_91087_().f_91073_;
        }
        if (level != null) {
            return level;
        }
        throw new Exception("Could not get dummy level from client, as there is no active level!");
    }

    @Override
    public void loadPlayerTrade(ClientPlayerTrade trade) {
        Minecraft mc = Minecraft.m_91087_();
        AbstractContainerMenu abstractContainerMenu = mc.f_91074_.f_36096_;
        if (abstractContainerMenu instanceof PlayerTradeMenu) {
            PlayerTradeMenu menu = (PlayerTradeMenu)abstractContainerMenu;
            menu.reloadTrade(trade);
        }
    }
}

