/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.items.IItemHandler;

public final class ItemRequirement
implements Predicate<ItemStack> {
    public static final ItemRequirement NULL = ItemRequirement.of((ItemStack s) -> false, 0);
    public final Predicate<ItemStack> filter;
    public final int count;

    private ItemRequirement(Predicate<ItemStack> filter, int count) {
        this.filter = filter;
        this.count = count;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.filter.test(stack);
    }

    public boolean isNull() {
        return this == NULL;
    }

    public ItemRequirement merge(ItemRequirement other) {
        return ItemRequirement.of(this.filter, this.count + other.count);
    }

    public static ItemRequirement of(Predicate<ItemStack> filter, int count) {
        return new ItemRequirement(filter, count);
    }

    public static ItemRequirement of(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return NULL;
        }
        return ItemRequirement.of((ItemStack s) -> InventoryUtil.ItemMatches(s, stack), stack.m_41613_());
    }

    public static ItemRequirement ofItemNoNBT(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return NULL;
        }
        return ItemRequirement.of(stack.m_41720_(), stack.m_41613_());
    }

    public static ItemRequirement of(Item item, int count) {
        if (item == null || item == Items.f_41852_) {
            return NULL;
        }
        return ItemRequirement.of((ItemStack s) -> s.m_41720_() == item, count);
    }

    public static List<ItemStack> getRandomItemsMatchingRequirements(IItemHandler container, ItemRequirement requirement1, ItemRequirement requirement2) {
        if (requirement1.isNull() && requirement2.isNull()) {
            return null;
        }
        if (requirement1.isNull()) {
            List<ItemStack> validItems = ItemRequirement.getValidItems(container, requirement2);
            if (validItems.size() == 0) {
                return null;
            }
            return Lists.newArrayList((Object[])new ItemStack[]{ItemRequirement.getRandomItem(validItems, requirement2.count)});
        }
        if (requirement2.isNull()) {
            List<ItemStack> validItems = ItemRequirement.getValidItems(container, requirement1);
            if (validItems.size() == 0) {
                return null;
            }
            return Lists.newArrayList((Object[])new ItemStack[]{ItemRequirement.getRandomItem(validItems, requirement1.count)});
        }
        List<ItemStack> validItems1 = ItemRequirement.getValidItems(container, requirement1);
        List<ItemStack> validItems2 = ItemRequirement.getValidItems(container, requirement2);
        for (int x = 0; x < validItems1.size(); ++x) {
            ItemStack s1 = validItems1.get(x);
            for (int y = 0; y < validItems2.size(); ++y) {
                int count;
                ItemStack s2 = validItems2.get(y);
                if (!InventoryUtil.ItemMatches(s1, s2) || (count = InventoryUtil.GetItemCount(container, s1)) >= requirement1.count + requirement2.count) continue;
                if (validItems2.size() == 1) {
                    validItems1.remove(s1);
                    --x;
                    continue;
                }
                validItems2.remove(s2);
                --y;
            }
        }
        if (validItems1.size() > 0 && validItems2.size() > 0) {
            return Lists.newArrayList((Object[])new ItemStack[]{ItemRequirement.getRandomItem(validItems1, requirement1.count), ItemRequirement.getRandomItem(validItems2, requirement2.count)});
        }
        return null;
    }

    public static List<ItemStack> getValidItems(IItemHandler container, ItemRequirement requirement) {
        ArrayList<ItemStack> validItems = new ArrayList<ItemStack>();
        for (int i = 0; i < container.getSlots(); ++i) {
            ItemStack stack = container.getStackInSlot(i);
            if (!requirement.test(stack) || InventoryUtil.GetItemCount(container, stack) < requirement.count || !ItemRequirement.isNotInList(validItems, stack)) continue;
            validItems.add(stack.m_41777_());
        }
        return validItems;
    }

    public static boolean isNotInList(List<ItemStack> list, ItemStack stack) {
        for (ItemStack i : list) {
            if (!InventoryUtil.ItemMatches(i, stack)) continue;
            return false;
        }
        return true;
    }

    public static ItemStack getRandomItem(List<ItemStack> validItems, int count) {
        if (validItems.size() == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = validItems.get(new Random().nextInt(validItems.size()));
        stack.m_41764_(count);
        return stack;
    }

    public static List<ItemStack> getFirstItemsMatchingRequirements(Container container, ItemRequirement ... requirements) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        HashMap<Integer, Integer> consumedItems = new HashMap<Integer, Integer>();
        for (ItemRequirement requirement : requirements) {
            int leftToConsume = requirement.count;
            for (int i = 0; i < container.m_6643_() && leftToConsume > 0; ++i) {
                ItemStack stack = container.m_8020_(i);
                if (!requirement.test(stack)) continue;
                int alreadyConsumed = consumedItems.getOrDefault(i, 0);
                int consumeCount = Math.min(leftToConsume, stack.m_41613_() - alreadyConsumed);
                leftToConsume -= consumeCount;
                if (consumeCount <= 0) continue;
                consumedItems.put(i, alreadyConsumed + consumeCount);
                boolean query = true;
                for (int x = 0; x < results.size() && query; ++x) {
                    if (!InventoryUtil.ItemMatches((ItemStack)results.get(x), stack)) continue;
                    query = false;
                    ((ItemStack)results.get(x)).m_41769_(consumeCount);
                }
                if (!query) continue;
                ItemStack result = stack.m_41777_();
                result.m_41764_(consumeCount);
                results.add(result);
            }
            if (leftToConsume <= 0) continue;
            return null;
        }
        return results;
    }

    public static List<ItemStack> getFirstItemsMatchingRequirements(IItemHandler container, ItemRequirement ... requirements) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        HashMap<Integer, Integer> consumedItems = new HashMap<Integer, Integer>();
        for (ItemRequirement requirement : requirements) {
            int leftToConsume = requirement.count;
            for (int i = 0; i < container.getSlots() && leftToConsume > 0; ++i) {
                ItemStack stack = container.getStackInSlot(i);
                if (!requirement.test(stack)) continue;
                int alreadyConsumed = consumedItems.getOrDefault(i, 0);
                int consumeCount = Math.min(leftToConsume, stack.m_41613_() - alreadyConsumed);
                leftToConsume -= consumeCount;
                if (consumeCount <= 0) continue;
                consumedItems.put(i, alreadyConsumed + consumeCount);
                boolean query = true;
                for (int x = 0; x < results.size() && query; ++x) {
                    if (!InventoryUtil.ItemMatches((ItemStack)results.get(x), stack)) continue;
                    query = false;
                    ((ItemStack)results.get(x)).m_41769_(consumeCount);
                }
                if (!query) continue;
                ItemStack result = stack.m_41777_();
                result.m_41764_(consumeCount);
                results.add(result);
            }
            if (leftToConsume <= 0) continue;
            return null;
        }
        return results;
    }
}

