/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util.config;

import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.util.CoinValueParser;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class CoinValueConfig
implements Supplier<CoinValue> {
    private final ForgeConfigSpec.ConfigValue<String> baseConfig;
    private final Supplier<CoinValue> defaultSupplier;
    private final Supplier<ForgeConfigSpec> specSupplier;
    private CoinValue cachedValue = null;

    private CoinValueConfig(ForgeConfigSpec.ConfigValue<String> baseConfig, Supplier<CoinValue> defaultSupplier, Supplier<ForgeConfigSpec> specSupplier) {
        this.baseConfig = baseConfig;
        this.defaultSupplier = defaultSupplier;
        this.specSupplier = specSupplier;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigReloaded);
    }

    public void onConfigReloaded(ModConfigEvent event) {
        if (event.getConfig().getSpec() == this.specSupplier.get()) {
            this.cachedValue = null;
        }
    }

    @Override
    public CoinValue get() {
        if (this.cachedValue == null) {
            String input = (String)this.baseConfig.get();
            this.cachedValue = CoinValueParser.ParseConfigString(input, this.defaultSupplier);
        }
        return this.cachedValue;
    }

    public static CoinValueConfig define(ForgeConfigSpec.Builder builder, String path, String defaultInput, CoinValue defaultValue, Supplier<ForgeConfigSpec> specSupplier) {
        return CoinValueConfig.define(builder, path, defaultInput, () -> defaultValue, specSupplier);
    }

    public static CoinValueConfig define(ForgeConfigSpec.Builder builder, String path, String defaultInput, Supplier<CoinValue> defaultValue, Supplier<ForgeConfigSpec> specSupplier) {
        ForgeConfigSpec.ConfigValue baseConfig = builder.define(path, (Object)defaultInput);
        return new CoinValueConfig((ForgeConfigSpec.ConfigValue<String>)baseConfig, defaultValue, specSupplier);
    }
}

