/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util.config;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemValueConfig
implements Supplier<Item> {
    private final ForgeConfigSpec.ConfigValue<String> baseConfig;
    private final Supplier<Item> defaultSupplier;
    private final Supplier<ForgeConfigSpec> specSupplier;
    private Predicate<Item> isAllowed = i -> true;
    private Item cachedItem = null;

    private ItemValueConfig(ForgeConfigSpec.ConfigValue<String> baseConfig, Supplier<Item> defaultSupplier, Supplier<ForgeConfigSpec> specSupplier) {
        this.baseConfig = baseConfig;
        this.defaultSupplier = defaultSupplier;
        this.specSupplier = specSupplier;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigReloaded);
    }

    public ItemValueConfig withCheck(@Nonnull Predicate<Item> isAllowed) {
        this.isAllowed = isAllowed;
        return this;
    }

    public void onConfigReloaded(ModConfigEvent event) {
        if (event.getConfig().getSpec() == this.specSupplier.get()) {
            this.cachedItem = null;
        }
    }

    @Override
    public Item get() {
        if (this.cachedItem != null) {
            return this.cachedItem;
        }
        String itemID = (String)this.baseConfig.get();
        try {
            this.cachedItem = itemID.isBlank() ? Items.f_41852_ : (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemID));
        }
        catch (Throwable t) {
            LightmansCurrency.LogDebug("Error loading item from config value.");
        }
        if (this.cachedItem == null) {
            this.cachedItem = this.defaultSupplier.get();
            LightmansCurrency.LogWarning("Could not load an item from a Config Input of \"" + itemID + "\". Assuming default value!");
        }
        return this.isAllowed.test(this.cachedItem) ? this.cachedItem : this.defaultSupplier.get();
    }

    private static Supplier<Item> convertDefault(ResourceLocation defaultItem) {
        return () -> (Item)ForgeRegistries.ITEMS.getValue(defaultItem);
    }

    private static boolean IsValidInput(Object o) {
        if (o instanceof String) {
            String s = (String)o;
            try {
                return ForgeRegistries.ITEMS.getValue(new ResourceLocation(s)) != null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static ItemValueConfig define(ForgeConfigSpec.Builder builder, String path, String defaultItem, Supplier<ForgeConfigSpec> specSupplier) {
        return ItemValueConfig.define(builder, path, new ResourceLocation(defaultItem), specSupplier);
    }

    public static ItemValueConfig define(ForgeConfigSpec.Builder builder, String path, ResourceLocation defaultItem, Supplier<ForgeConfigSpec> specSupplier) {
        return ItemValueConfig.define(builder, path, defaultItem, ItemValueConfig.convertDefault(defaultItem), specSupplier);
    }

    public static ItemValueConfig define(ForgeConfigSpec.Builder builder, String path, ResourceLocation defaultItem, Supplier<Item> defaultItemSupplier, Supplier<ForgeConfigSpec> specSupplier) {
        ForgeConfigSpec.ConfigValue baseConfig = builder.define(path, (Object)defaultItem.toString(), ItemValueConfig::IsValidInput);
        return new ItemValueConfig((ForgeConfigSpec.ConfigValue<String>)baseConfig, defaultItemSupplier, specSupplier);
    }
}

