/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.scannable.common.container.AbstractModuleContainerMenu;
import li.cil.scannable.common.network.Network;
import li.cil.scannable.common.network.message.RemoveConfiguredModuleItemAtMessage;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractConfigurableScannerModuleContainerScreen<TContainer extends AbstractModuleContainerMenu, TItem>
extends AbstractContainerScreen<TContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("scannable", "textures/gui/container/configurable_module.png");
    public static final int SLOTS_ORIGIN_X = 62;
    public static final int SLOTS_ORIGIN_Y = 20;
    public static final int SLOT_SIZE = 18;
    private final Component listCaption;
    private final Inventory inventory;

    public AbstractConfigurableScannerModuleContainerScreen(TContainer container, Inventory inventory, Component title, Component listCaption) {
        super(container, inventory, title);
        this.listCaption = listCaption;
        this.inventory = inventory;
        this.f_97727_ = 133;
        this.f_96546_ = false;
        this.f_97730_ = 8;
        this.f_97731_ = 39;
    }

    private ItemStack getHeldItem() {
        return ((AbstractModuleContainerMenu)this.f_97732_).getPlayer().m_21120_(((AbstractModuleContainerMenu)this.f_97732_).getHand());
    }

    protected abstract List<TItem> getConfiguredItems(ItemStack var1);

    protected abstract Component getItemName(TItem var1);

    protected abstract void renderConfiguredItem(TItem var1, int var2, int var3);

    protected void configureItemAt(ItemStack stack, int slot, ItemStack value) {
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
        ItemStack stack = this.getHeldItem();
        List<TItem> items = this.getConfiguredItems(stack);
        for (int slot = 0; slot < Math.min(items.size(), 5); ++slot) {
            int x = 62 + slot * 18;
            int y = 20;
            if (!this.m_6774_(x, 20, 16, 16, mouseX, mouseY)) continue;
            TItem item = items.get(slot);
            this.m_96602_(poseStack, this.getItemName(item), mouseX, mouseY);
        }
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7027_(poseStack, mouseX, mouseY);
        this.f_96547_.m_92889_(poseStack, this.listCaption, 8.0f, 23.0f, 0x404040);
        ItemStack stack = this.getHeldItem();
        List<TItem> items = this.getConfiguredItems(stack);
        for (int slot = 0; slot < 5; ++slot) {
            int x = 62 + slot * 18;
            int y = 20;
            if (this.m_6774_(x, 20, 16, 16, mouseX, mouseY)) {
                AbstractConfigurableScannerModuleContainerScreen.m_169606_((PoseStack)poseStack, (int)x, (int)20, (int)400);
            }
            if (slot >= items.size()) continue;
            TItem item = items.get(slot);
            this.renderConfiguredItem(item, x, 20);
        }
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (int slot = 0; slot < 5; ++slot) {
            int x = 62 + slot * 18;
            int y = 20;
            if (!this.m_6774_(x, 20, 18, 18, mouseX, mouseY)) continue;
            ItemStack heldItemStack = ((AbstractModuleContainerMenu)this.f_97732_).m_142621_();
            if (!heldItemStack.m_41619_()) {
                this.configureItemAt(this.getHeldItem(), slot, heldItemStack);
            } else {
                Network.INSTANCE.sendToServer((Object)new RemoveConfiguredModuleItemAtMessage(((AbstractModuleContainerMenu)this.f_97732_).f_38840_, slot));
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_6597_(@Nullable Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot != null) {
            ItemStack heldItem = this.getHeldItem();
            if (slot.m_7993_() == heldItem) {
                return;
            }
            if (type == ClickType.SWAP && this.inventory.m_8020_(mouseButton) == heldItem) {
                return;
            }
        }
        super.m_6597_(slot, slotId, mouseButton, type);
    }
}

