/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import li.cil.scannable.client.gui.AbstractConfigurableScannerModuleContainerScreen;
import li.cil.scannable.common.config.Strings;
import li.cil.scannable.common.container.EntityModuleContainerMenu;
import li.cil.scannable.common.item.ConfigurableEntityScannerModuleItem;
import li.cil.scannable.common.network.Network;
import li.cil.scannable.common.network.message.SetConfiguredModuleItemAtMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ConfigurableEntityScannerModuleContainerScreen
extends AbstractConfigurableScannerModuleContainerScreen<EntityModuleContainerMenu, EntityType<?>> {
    private static final Map<EntityType<?>, Entity> RENDER_ENTITIES = new HashMap();

    public ConfigurableEntityScannerModuleContainerScreen(EntityModuleContainerMenu container, Inventory inventory, Component title) {
        super(container, inventory, title, Strings.GUI_ENTITIES_LIST_CAPTION);
    }

    @Override
    protected List<EntityType<?>> getConfiguredItems(ItemStack stack) {
        return ConfigurableEntityScannerModuleItem.getEntityTypes(stack);
    }

    @Override
    protected Component getItemName(EntityType<?> entityType) {
        return entityType.m_20676_();
    }

    @Override
    protected void renderConfiguredItem(EntityType<?> entityType, int x, int y) {
        this.renderEntity(x + 8, y + 13, entityType);
    }

    @Override
    protected void configureItemAt(ItemStack stack, int slot, ItemStack value) {
        EntityType entityType;
        ResourceLocation registryName;
        if (value.m_41720_() instanceof SpawnEggItem && (registryName = (entityType = ((SpawnEggItem)value.m_41720_()).m_43228_(value.m_41783_())).getRegistryName()) != null) {
            Network.INSTANCE.sendToServer((Object)new SetConfiguredModuleItemAtMessage(((EntityModuleContainerMenu)this.f_97732_).f_38840_, slot, registryName));
        }
    }

    private void renderEntity(int x, int y, EntityType<?> entityType) {
        Entity entity = this.getRenderEntity(entityType);
        if (entity == null) {
            return;
        }
        entity.f_19853_ = ((EntityModuleContainerMenu)this.f_97732_).getPlayer().f_19853_;
        EntityDimensions bounds = entityType.m_20680_();
        float size = Math.max(bounds.f_20377_, bounds.f_20378_);
        float scale = 11.0f / size;
        PoseStack poseStack = new PoseStack();
        poseStack.m_85837_((double)x, (double)y, 0.0);
        poseStack.m_85841_(scale, scale, scale);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        quaternion.m_80148_(Vector3f.f_122222_.m_122240_(-20.0f));
        quaternion.m_80148_(Vector3f.f_122225_.m_122240_(30.0f));
        poseStack.m_85845_(quaternion);
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        quaternion.m_80157_();
        renderManager.m_114412_(quaternion);
        renderManager.m_114468_(false);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        renderManager.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)buffer, 0xF000F0);
        buffer.m_109911_();
        renderManager.m_114468_(true);
    }

    @Nullable
    private Entity getRenderEntity(EntityType<?> entityType) {
        return RENDER_ENTITIES.computeIfAbsent(entityType, t -> t.m_20615_(((EntityModuleContainerMenu)this.f_97732_).getPlayer().f_19853_));
    }
}

