/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.renderer;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import li.cil.scannable.client.ScanManager;
import li.cil.scannable.client.shader.Shaders;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL30;

@OnlyIn(value=Dist.CLIENT)
public enum ScannerRenderer {
    INSTANCE;

    private int depthCopyFbo;
    private int depthCopyColorBuffer;
    private int depthCopyDepthBuffer;
    private long currentStart;
    private Vec3 currentCenter;

    public void ping(Vec3 pos) {
        this.currentStart = System.currentTimeMillis();
        this.currentCenter = pos;
    }

    public static void render(PoseStack poseStack) {
        INSTANCE.doRender(poseStack);
    }

    public void doRender(PoseStack poseStack) {
        boolean shouldRender;
        int adjustedDuration = ScanManager.computeScanGrowthDuration();
        boolean bl = shouldRender = this.currentStart > 0L && adjustedDuration > (int)(System.currentTimeMillis() - this.currentStart);
        if (shouldRender) {
            if (this.depthCopyFbo == 0) {
                this.createDepthCopyBuffer();
            }
            this.render(poseStack.m_85850_().m_85861_());
        } else {
            if (this.depthCopyFbo != 0) {
                this.deleteDepthCopyBuffer();
            }
            this.currentStart = 0L;
        }
    }

    private void render(Matrix4f viewMatrix) {
        ShaderInstance shader = Shaders.getScanEffectShader();
        if (shader == null) {
            return;
        }
        RenderTarget target = Minecraft.m_91087_().m_91385_();
        this.updateDepthTexture(target);
        this.updateShaderUniforms(shader, viewMatrix);
        this.blit(target);
    }

    private void updateDepthTexture(RenderTarget target) {
        int oldBuffer = GlStateManager.m_157114_();
        GlStateManager.m_84486_((int)36008, (int)target.f_83920_);
        GlStateManager.m_84486_((int)36009, (int)this.depthCopyFbo);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)target.f_83915_, (int)target.f_83916_, (int)0, (int)0, (int)target.f_83915_, (int)target.f_83916_, (int)256, (int)9728);
        GlStateManager.m_84486_((int)36160, (int)oldBuffer);
    }

    private void updateShaderUniforms(ShaderInstance shader, Matrix4f viewMatrix) {
        Matrix4f invertedViewMatrix = new Matrix4f(viewMatrix);
        invertedViewMatrix.m_27657_();
        Matrix4f invertedProjectionMatrix = new Matrix4f(RenderSystem.m_157192_());
        invertedProjectionMatrix.m_27657_();
        Vec3 cameraPosition = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        int adjustedDuration = ScanManager.computeScanGrowthDuration();
        float radius = ScanManager.computeRadius(this.currentStart, adjustedDuration);
        shader.m_173350_("depthTex", (Object)this.depthCopyDepthBuffer);
        shader.m_173356_("center").m_142276_(new Vector3f(this.currentCenter));
        shader.m_173356_("invViewMat").m_5679_(invertedViewMatrix);
        shader.m_173356_("invProjMat").m_5679_(invertedProjectionMatrix);
        shader.m_173356_("pos").m_142276_(new Vector3f(cameraPosition));
        shader.m_173356_("radius").m_5985_(radius);
    }

    private void blit(RenderTarget target) {
        int width = target.f_83915_;
        int height = target.f_83916_;
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        ShaderInstance oldShader = RenderSystem.m_157196_();
        RenderSystem.m_157427_(Shaders::getScanEffectShader);
        RenderSystem.m_157183_();
        RenderSystem.m_157425_((Matrix4f)Matrix4f.m_162203_((float)0.0f, (float)width, (float)0.0f, (float)height, (float)1.0f, (float)100.0f));
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(0.0, (double)height, -50.0).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_5483_((double)width, (double)height, -50.0).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_5483_((double)width, 0.0, -50.0).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_5483_(0.0, 0.0, -50.0).m_7421_(0.0f, 1.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_157424_();
        RenderSystem.m_157427_(() -> oldShader);
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
    }

    private void createDepthCopyBuffer() {
        RenderTarget target = Minecraft.m_91087_().m_91385_();
        this.depthCopyFbo = GlStateManager.m_84543_();
        this.depthCopyColorBuffer = this.createTexture(target.f_83915_, target.f_83916_, 32856, 6408, 5121);
        this.depthCopyDepthBuffer = this.createTexture(target.f_83915_, target.f_83916_, 6402, 6402, 5126);
        int oldBuffer = GlStateManager.m_157114_();
        GlStateManager.m_84486_((int)36160, (int)this.depthCopyFbo);
        GlStateManager.m_84173_((int)36160, (int)36064, (int)3553, (int)this.depthCopyColorBuffer, (int)0);
        GlStateManager.m_84173_((int)36160, (int)36096, (int)3553, (int)this.depthCopyDepthBuffer, (int)0);
        GlStateManager.m_84486_((int)36160, (int)oldBuffer);
    }

    private void deleteDepthCopyBuffer() {
        GlStateManager.m_84502_((int)this.depthCopyFbo);
        this.depthCopyFbo = 0;
        TextureUtil.m_85281_((int)this.depthCopyColorBuffer);
        this.depthCopyColorBuffer = 0;
        TextureUtil.m_85281_((int)this.depthCopyDepthBuffer);
        this.depthCopyDepthBuffer = 0;
    }

    private int createTexture(int width, int height, int internalFormat, int format, int type) {
        int texture = TextureUtil.m_85280_();
        GlStateManager.m_84544_((int)texture);
        GlStateManager.m_84331_((int)3553, (int)10242, (int)10497);
        GlStateManager.m_84331_((int)3553, (int)10243, (int)10497);
        GlStateManager.m_84331_((int)3553, (int)10241, (int)9728);
        GlStateManager.m_84331_((int)3553, (int)10240, (int)9728);
        GlStateManager.m_84209_((int)3553, (int)0, (int)internalFormat, (int)width, (int)height, (int)0, (int)format, (int)type, null);
        GlStateManager.m_84544_((int)0);
        return texture;
    }
}

