/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.scannable.common.config.CommonConfig;
import li.cil.scannable.common.energy.ScannerEnergyStorage;
import li.cil.scannable.common.inventory.ScannerItemHandler;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class ScannerWrapper
implements ICapabilityProvider {
    private final ScannerItemHandler itemHandler;
    private final ScannerEnergyStorage energyStorage;
    private final LazyOptional<IItemHandler> itemHandlerHolder;
    private final LazyOptional<IEnergyStorage> energyStorageHolder;

    public ScannerWrapper(ItemStack container) {
        this.itemHandler = new ScannerItemHandler(container);
        this.energyStorage = new ScannerEnergyStorage(container);
        this.itemHandlerHolder = LazyOptional.of(() -> {
            this.itemHandler.updateFromNBT();
            return this.itemHandler;
        });
        this.energyStorageHolder = LazyOptional.of(() -> {
            this.energyStorage.updateFromNBT();
            return this.energyStorage;
        });
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        LazyOptional itemHandlerCapability = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.itemHandlerHolder);
        if (itemHandlerCapability.isPresent()) {
            return itemHandlerCapability;
        }
        LazyOptional energyCapability = CapabilityEnergy.ENERGY.orEmpty(capability, this.energyStorageHolder);
        if (CommonConfig.useEnergy && energyCapability.isPresent()) {
            return energyCapability;
        }
        return LazyOptional.empty();
    }
}

