/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.scannable.api.scanning.ScannerModule;
import li.cil.scannable.client.ScanManager;
import li.cil.scannable.client.audio.SoundManager;
import li.cil.scannable.common.capabilities.Capabilities;
import li.cil.scannable.common.capabilities.ScannerWrapper;
import li.cil.scannable.common.config.CommonConfig;
import li.cil.scannable.common.config.Strings;
import li.cil.scannable.common.container.ScannerContainerMenu;
import li.cil.scannable.common.energy.ScannerEnergyStorage;
import li.cil.scannable.common.inventory.ScannerItemHandler;
import li.cil.scannable.common.item.Items;
import li.cil.scannable.common.item.ModItem;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public final class ScannerItem
extends ModItem {
    public static boolean isScanner(ItemStack stack) {
        return stack.m_41720_() == Items.SCANNER.get();
    }

    public ScannerItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag tag) {
        return new ScannerWrapper(stack);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        super.m_6787_(group, items);
        if (this.m_41389_(group) && CommonConfig.useEnergy) {
            ItemStack stack = new ItemStack((ItemLike)this);
            ScannerEnergyStorage.of(stack).receiveEnergy(Integer.MAX_VALUE, false);
            items.add((Object)stack);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (CommonConfig.useEnergy) {
            ScannerEnergyStorage energyStorage = ScannerEnergyStorage.of(stack);
            tooltip.add(Strings.energyStorage(energyStorage.getEnergyStored(), energyStorage.getMaxEnergyStored()));
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return CommonConfig.useEnergy;
    }

    public int m_142158_(ItemStack stack) {
        return (int)(ScannerItem.getRelativeEnergy(stack) * 13.0f);
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)(ScannerItem.getRelativeEnergy(stack) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, final InteractionHand hand) {
        final ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (!level.m_5776_() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                    if (itemHandler instanceof ScannerItemHandler) {
                        final ScannerItemHandler scannerItemHandler = (ScannerItemHandler)((Object)itemHandler);
                        NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                            public Component m_5446_() {
                                return stack.m_41786_();
                            }

                            public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                                return new ScannerContainerMenu(id, inventory, hand, scannerItemHandler);
                            }
                        }, buffer -> buffer.m_130068_((Enum)hand));
                    }
                });
            }
        } else {
            ArrayList<ItemStack> modules = new ArrayList<ItemStack>();
            if (!ScannerItem.collectModules(stack, modules)) {
                if (!level.m_5776_()) {
                    player.m_5661_(Strings.MESSAGE_NO_SCAN_MODULES, true);
                }
                player.m_36335_().m_41524_((Item)this, 10);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (!ScannerItem.tryConsumeEnergy(player, stack, modules, true)) {
                if (!level.m_5776_()) {
                    player.m_5661_(Strings.MESSAGE_NOT_ENOUGH_ENERGY, true);
                }
                player.m_36335_().m_41524_((Item)this, 10);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            player.m_6672_(hand);
            if (level.m_5776_()) {
                ScanManager.beginScan(player, modules);
                SoundManager.playChargingSound();
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_() || slotChanged;
    }

    public int m_8105_(ItemStack stack) {
        return 40;
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        if (entity.f_19853_.m_5776_()) {
            ScanManager.updateScan((Entity)entity, false);
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (level.m_5776_()) {
            ScanManager.cancelScan();
            SoundManager.stopChargingSound();
        }
        super.m_5551_(stack, level, entity, timeLeft);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        ArrayList<ItemStack> modules;
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        if (level.m_5776_()) {
            SoundCanceler.cancelEquipSound();
        }
        if (!ScannerItem.collectModules(stack, modules = new ArrayList<ItemStack>())) {
            return stack;
        }
        boolean hasEnergy = ScannerItem.tryConsumeEnergy((Player)entity, stack, modules, false);
        if (level.m_5776_()) {
            SoundManager.stopChargingSound();
            if (hasEnergy) {
                ScanManager.updateScan((Entity)entity, true);
                SoundManager.playActivateSound();
            } else {
                ScanManager.cancelScan();
            }
        }
        player.m_36335_().m_41524_((Item)this, 40);
        return stack;
    }

    static int getModuleEnergyCost(ItemStack stack) {
        if (!CommonConfig.useEnergy || Capabilities.SCANNER_MODULE_CAPABILITY == null) {
            return 0;
        }
        return stack.getCapability(Capabilities.SCANNER_MODULE_CAPABILITY).map(module -> module.getEnergyCost(stack)).orElse(0);
    }

    private static float getRelativeEnergy(ItemStack stack) {
        if (!CommonConfig.useEnergy) {
            return 0.0f;
        }
        return stack.getCapability(CapabilityEnergy.ENERGY).map(storage -> Float.valueOf((float)storage.getEnergyStored() / (float)storage.getMaxEnergyStored())).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private static boolean tryConsumeEnergy(Player player, ItemStack scanner, List<ItemStack> modules, boolean simulate) {
        if (!CommonConfig.useEnergy) {
            return true;
        }
        if (player.m_7500_()) {
            return true;
        }
        LazyOptional energyStorage = scanner.getCapability(CapabilityEnergy.ENERGY);
        if (!energyStorage.isPresent()) {
            return false;
        }
        int totalCostAccumulator = 0;
        for (ItemStack module : modules) {
            totalCostAccumulator += ScannerItem.getModuleEnergyCost(module);
        }
        int totalCost = totalCostAccumulator;
        int extracted = energyStorage.map(storage -> storage.extractEnergy(totalCost, simulate)).orElse(0);
        return extracted >= totalCost;
    }

    private static boolean collectModules(ItemStack scanner, List<ItemStack> modules) {
        return scanner.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(itemHandler -> {
            boolean hasScannerModules = false;
            if (itemHandler instanceof ScannerItemHandler) {
                ScannerItemHandler scannerItemHandler = (ScannerItemHandler)((Object)itemHandler);
                IItemHandler activeModules = scannerItemHandler.getActiveModules();
                for (int slot = 0; slot < activeModules.getSlots(); ++slot) {
                    ItemStack module = activeModules.getStackInSlot(slot);
                    if (module.m_41619_()) continue;
                    modules.add(module);
                    hasScannerModules |= module.getCapability(Capabilities.SCANNER_MODULE_CAPABILITY).map(ScannerModule::hasResultProvider).orElse(false).booleanValue();
                }
            }
            return hasScannerModules;
        }).orElse(false);
    }

    private static enum SoundCanceler {
        INSTANCE;


        public static void cancelEquipSound() {
            MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        }

        @SubscribeEvent
        public void onPlaySoundAtEntityEvent(PlaySoundAtEntityEvent event) {
            if (event.getSound() == SoundEvents.f_11675_) {
                event.setCanceled(true);
            }
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }
}

