/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.scanning;

import java.util.List;
import java.util.function.Predicate;
import li.cil.scannable.api.scanning.BlockScannerModule;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.client.scanning.ScanResultProviders;
import li.cil.scannable.client.scanning.filter.BlockCacheScanFilter;
import li.cil.scannable.common.config.CommonConfig;
import li.cil.scannable.common.item.ConfigurableBlockScannerModuleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum ConfigurableBlockScannerModule implements BlockScannerModule
{
    INSTANCE;


    @Override
    public int getEnergyCost(ItemStack module) {
        return CommonConfig.energyCostModuleBlock;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScanResultProvider getResultProvider() {
        return (ScanResultProvider)ScanResultProviders.BLOCKS.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float adjustLocalRange(float range) {
        return range * 0.5f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Predicate<BlockState> getFilter(ItemStack module) {
        List<Block> blocks = ConfigurableBlockScannerModuleItem.getBlocks(module);
        return new BlockCacheScanFilter(blocks);
    }
}

