/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.scanning.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import li.cil.scannable.common.config.CommonConfig;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

@Mod.EventBusSubscriber(modid="scannable", bus=Mod.EventBusSubscriber.Bus.MOD)
public enum IgnoredBlocks {
    INSTANCE;

    private Set<Block> ignoredBlocks;

    public static boolean contains(BlockState state) {
        INSTANCE.validateFilter();
        return IgnoredBlocks.INSTANCE.ignoredBlocks.contains(state.m_60734_());
    }

    private void validateFilter() {
        if (this.ignoredBlocks != null) {
            return;
        }
        HashSet<Block> ignoredBlocks = new HashSet<Block>();
        for (ResourceLocation location : CommonConfig.ignoredBlocks) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
            if (block == null) continue;
            ignoredBlocks.add(block);
        }
        ArrayList<TagKey> ignoredTags = new ArrayList<TagKey>();
        ITagManager tags = ForgeRegistries.BLOCKS.tags();
        if (tags != null) {
            for (ResourceLocation location : CommonConfig.ignoredBlockTags) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)location);
                if (!tags.isKnownTagName(tag)) continue;
                ignoredTags.add(tag);
            }
        }
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            BlockState blockState = block.m_49966_();
            if (!ignoredTags.stream().anyMatch(arg_0 -> ((BlockState)blockState).m_204336_(arg_0))) continue;
            ignoredBlocks.add(blockState.m_60734_());
        }
        this.ignoredBlocks = ignoredBlocks;
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        IgnoredBlocks.INSTANCE.ignoredBlocks = null;
    }
}

