/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client;

import java.util.function.Supplier;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.tropicraft.core.client.tileentity.SimpleItemStackRenderer;
import net.tropicraft.core.common.block.AirCompressorBlock;
import net.tropicraft.core.common.block.BambooChestBlock;
import net.tropicraft.core.common.block.DrinkMixerBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.tileentity.AirCompressorBlockEntity;
import net.tropicraft.core.common.block.tileentity.BambooChestBlockEntity;
import net.tropicraft.core.common.block.tileentity.DrinkMixerBlockEntity;

public final class TropicraftItemRenderers {
    public static IItemRenderProperties bambooChest() {
        return TropicraftItemRenderers.renderItemAsBlockEntity(() -> new BambooChestBlockEntity((BlockEntityType<BambooChestBlockEntity>)((BlockEntityType)TropicraftBlocks.BAMBOO_CHEST_ENTITY.get()), BlockPos.f_121853_, ((BambooChestBlock)TropicraftBlocks.BAMBOO_CHEST.get()).m_49966_()));
    }

    public static IItemRenderProperties drinkMixer() {
        return TropicraftItemRenderers.renderItemAsBlockEntity(() -> new DrinkMixerBlockEntity((BlockEntityType<DrinkMixerBlockEntity>)((BlockEntityType)TropicraftBlocks.DRINK_MIXER_ENTITY.get()), BlockPos.f_121853_, ((DrinkMixerBlock)TropicraftBlocks.DRINK_MIXER.get()).m_49966_()));
    }

    public static IItemRenderProperties airCompressor() {
        return TropicraftItemRenderers.renderItemAsBlockEntity(() -> new AirCompressorBlockEntity((BlockEntityType<AirCompressorBlockEntity>)((BlockEntityType)TropicraftBlocks.AIR_COMPRESSOR_ENTITY.get()), BlockPos.f_121853_, ((AirCompressorBlock)TropicraftBlocks.AIR_COMPRESSOR.get()).m_49966_()));
    }

    public static IItemRenderProperties renderItemAsBlockEntity(final Supplier<BlockEntity> blockEntityFactory) {
        return new IItemRenderProperties(){

            @OnlyIn(value=Dist.CLIENT)
            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return new SimpleItemStackRenderer(blockEntityFactory);
            }
        };
    }
}

