/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;

public class TropicraftRenderUtils {
    private static Map<String, ResourceLocation> resLocMap = Maps.newHashMap();
    private static Map<String, Material> materialMap = Maps.newHashMap();

    public static VertexConsumer getEntityCutoutBuilder(MultiBufferSource buffer, ResourceLocation resourceLocation) {
        return buffer.m_6299_(RenderType.m_110452_((ResourceLocation)resourceLocation));
    }

    public static BakedModel getBakedModel(ItemRenderer itemRenderer, ItemStack itemStack) {
        return itemRenderer.m_115103_().m_109406_(itemStack);
    }

    public static void renderModel(Material material, Model model, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        model.m_7695_(stack, buffer.m_6299_(model.m_103119_(material.m_119203_())), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static Material getBlockMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> TropicraftRenderUtils.createBlockMaterial(path));
    }

    private static Material createBlockMaterial(String path) {
        return new Material(TextureAtlas.f_118259_, TropicraftRenderUtils.getTextureBlock(path));
    }

    public static Material getTEMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> TropicraftRenderUtils.createTEMaterial(path));
    }

    private static Material createTEMaterial(String path) {
        return new Material(TextureAtlas.f_118259_, TropicraftRenderUtils.getTextureTE(path));
    }

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> TropicraftRenderUtils.getResLoc(path));
    }

    private static ResourceLocation getResLoc(String path) {
        return new ResourceLocation("tropicraft", path);
    }

    public static ResourceLocation getTextureArmor(String path) {
        return TropicraftRenderUtils.getTexture(String.format("textures/models/armor/%s.png", path));
    }

    public static ResourceLocation getTextureBlock(String path) {
        return TropicraftRenderUtils.getTexture(String.format("textures/block/%s.png", path));
    }

    public static ResourceLocation getTextureEntity(String path) {
        return TropicraftRenderUtils.getTexture(String.format("textures/entity/%s.png", path));
    }

    public static ResourceLocation getTextureGui(String path) {
        return TropicraftRenderUtils.getTexture(String.format("textures/gui/%s.png", path));
    }

    public static ResourceLocation getTextureTE(String path) {
        return TropicraftRenderUtils.getTexture(String.format("textures/block/te/%s.png", path));
    }

    public static ResourceLocation bindTextureArmor(String path) {
        return TropicraftRenderUtils.bindTexture(TropicraftRenderUtils.getTextureArmor(path));
    }

    public static ResourceLocation bindTextureEntity(String path) {
        return TropicraftRenderUtils.bindTexture(TropicraftRenderUtils.getTextureEntity(path));
    }

    public static ResourceLocation bindTextureGui(String path) {
        return TropicraftRenderUtils.bindTexture(TropicraftRenderUtils.getTextureGui(path));
    }

    public static ResourceLocation bindTextureTE(String path) {
        return TropicraftRenderUtils.bindTexture(TropicraftRenderUtils.getTextureTE(path));
    }

    public static ResourceLocation bindTextureBlock(String path) {
        return TropicraftRenderUtils.bindTexture(TropicraftRenderUtils.getTextureBlock(path));
    }

    public static ResourceLocation bindTexture(ResourceLocation resource) {
        Minecraft.m_91087_().m_91097_().m_174784_(resource);
        return resource;
    }

    public static void renderItem(ItemStack itemStack, float scale, boolean leftHand, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn, BakedModel modelIn, int seed) {
        if (!itemStack.m_41619_()) {
            stack.m_85836_();
            stack.m_85841_(scale, scale, scale);
            if (itemStack.m_41720_() instanceof PlayerHeadItem) {
                stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            }
            Minecraft.m_91087_().m_91291_().m_174269_(itemStack, ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, stack, buffer, seed);
            stack.m_85849_();
        }
    }
}

