/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.tropicraft.core.common.entity.hostile.AshenEntity;

public class AshenModel
extends ListModel<AshenEntity>
implements ArmedModel {
    public ModelPart rightLeg;
    public ModelPart leftLeg;
    public ModelPart body;
    public ModelPart head;
    public ModelPart rightArm;
    public ModelPart leftArm;
    public ModelPart rightArmSub;
    public ModelPart leftArmSub;
    public float headAngle;
    public boolean swinging;
    public static int textureWidth;
    public static int textureHeight;

    public AshenModel(ModelPart root) {
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.rightArm = root.m_171324_("right_arm");
        this.leftArm = root.m_171324_("left_arm");
        this.rightArmSub = this.rightArm.m_171324_("right_arm_sub");
        this.leftArmSub = this.leftArm.m_171324_("left_arm_sub");
        textureWidth = 64;
        textureHeight = 32;
        boolean swinging = false;
        float headAngle = 0.0f;
    }

    public static LayerDefinition create() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(25, 0).m_171480_().m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 7.0f, 1.0f), PartPose.m_171423_((float)1.0f, (float)17.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(25, 0).m_171480_().m_171481_(-1.0f, 0.0f, 0.0f, 1.0f, 7.0f, 1.0f), PartPose.m_171423_((float)-1.0f, (float)17.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(24, 8).m_171480_().m_171481_(-2.0f, -3.0f, 0.0f, 4.0f, 7.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)13.0f, (float)2.0f, (float)0.0f, (float)3.141593f, (float)0.0f));
        modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(24, 18).m_171480_().m_171481_(-2.0f, -3.0f, -1.0f, 4.0f, 3.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)1.0f, (float)0.0f, (float)3.141593f, (float)0.0f));
        PartDefinition modelPartDataRightArm = modelPartData.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171480_().m_171481_(-6.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.m_171423_((float)-2.0f, (float)10.5f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        modelPartDataRightArm.m_171599_("right_arm_sub", CubeListBuilder.m_171558_().m_171514_(31, 0).m_171480_().m_171481_(-0.5f, -6.0f, -0.5f, 1.0f, 6.0f, 1.0f), PartPose.m_171423_((float)-5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition modelPartDataLeftArm = modelPartData.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171480_().m_171481_(0.0f, -0.5f, -0.5f, 6.0f, 1.0f, 1.0f), PartPose.m_171423_((float)2.0f, (float)10.46667f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        modelPartDataLeftArm.m_171599_("left_arm_sub", CubeListBuilder.m_171558_().m_171555_(true).m_171514_(31, 0).m_171481_(-0.5f, -6.0f, -0.5f, 1.0f, 6.0f, 1.0f), PartPose.m_171423_((float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)32);
    }

    public void setupAnim(AshenEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch / 125.0f + this.headAngle;
        this.head.f_104204_ = netHeadYaw / 125.0f + 3.14159f;
        float armRotater = 1.247196f;
        float subStraight = 1.570795f;
        switch (entityIn.getActionState()) {
            case LOST_MASK: {
                this.headAngle = -0.4f;
                this.rightArm.f_104205_ = -1.247196f;
                this.rightArmSub.f_104205_ = -5.1f;
                this.leftArm.f_104205_ = 1.247196f;
                this.leftArmSub.f_104205_ = 5.1f;
                this.leftArm.f_104203_ = 1.570795f;
                this.rightArm.f_104203_ = 1.570795f;
                this.rightArm.f_104204_ = -0.5f;
                this.leftArm.f_104204_ = 0.5f;
                break;
            }
            case HOSTILE: {
                this.headAngle = 0.0f;
                this.leftArm.f_104203_ = 1.65f + limbSwing / 125.0f;
                this.leftArm.f_104204_ = 0.9f + limbSwingAmount / 125.0f;
                this.leftArm.f_104205_ = 1.247196f;
                this.leftArmSub.f_104205_ = 6.2f;
                this.rightArm.f_104205_ = 0.0f - Mth.m_14031_((float)(limbSwingAmount * 0.75f)) * 0.022f;
                this.rightArm.f_104204_ = 0.0f;
                this.rightArmSub.f_104205_ = 0.0f;
                if (this.swinging) {
                    this.rightArm.f_104203_ += Mth.m_14031_((float)(limbSwingAmount * 0.75f)) * 0.052f;
                    break;
                }
                this.rightArm.f_104203_ = 0.0f;
                break;
            }
            default: {
                this.headAngle = 0.0f;
                this.rightArm.f_104205_ = -1.247196f;
                this.rightArmSub.f_104205_ = -1.570795f;
                this.leftArm.f_104205_ = 1.247196f;
                this.leftArmSub.f_104205_ = 1.570795f;
                this.rightArm.f_104204_ = 0.0f;
                this.leftArm.f_104204_ = 0.0f;
            }
        }
        this.leftArm.f_104205_ += Mth.m_14031_((float)(ageInTicks * 0.25f)) * 0.02f;
        this.rightArm.f_104205_ -= Mth.m_14031_((float)(ageInTicks * 0.25f)) * 0.02f;
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.body, (Object)this.head, (Object)this.rightArm, (Object)this.leftArm, (Object)this.leftLeg, (Object)this.rightLeg);
    }

    private void setRotation(ModelPart model, float x, float y, float z) {
        model.f_104203_ = x;
        model.f_104204_ = y;
        model.f_104205_ = z;
    }

    public void prepareMobModel(AshenEntity entity, float f, float f1, float f2) {
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f)) * 1.25f * f1;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(f * 0.6662f + 3.141593f)) * 1.25f * f1;
    }

    public void m_6002_(HumanoidArm side, PoseStack stack) {
        stack.m_85837_(0.09375, 0.1875, 0.0);
    }
}

