/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class BambooMugModel
extends Model {
    public ModelPart base;
    public ModelPart wall1;
    public ModelPart wall2;
    public ModelPart wall3;
    public ModelPart wall4;
    public ModelPart liquid;
    public ModelPart handletop;
    public ModelPart handlebottom;
    public ModelPart handle;
    public boolean renderLiquid;
    public int liquidColor;

    public BambooMugModel(ModelPart root, Function<ResourceLocation, RenderType> renderTypeIn) {
        super(renderTypeIn);
        this.base = root.m_171324_("base");
        this.wall1 = root.m_171324_("wall1");
        this.wall2 = root.m_171324_("wall2");
        this.wall3 = root.m_171324_("wall3");
        this.wall4 = root.m_171324_("wall4");
        this.liquid = root.m_171324_("liquid");
        this.handletop = root.m_171324_("handletop");
        this.handlebottom = root.m_171324_("handlebottom");
        this.handle = root.m_171324_("handle");
    }

    public static LayerDefinition create() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(10, 0).m_171480_().m_171481_(-2.0f, 23.0f, -2.0f, 4.0f, 1.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("wall1", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171480_().m_171481_(-2.0f, 17.0f, -3.0f, 4.0f, 6.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("wall2", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171480_().m_171481_(-2.0f, 17.0f, 2.0f, 4.0f, 6.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("wall3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(2.0f, 17.0f, -2.0f, 1.0f, 6.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("wall4", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171481_(-3.0f, 17.0f, -2.0f, 1.0f, 6.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("liquid", CubeListBuilder.m_171558_().m_171514_(10, 5).m_171480_().m_171481_(-2.0f, 18.0f, -2.0f, 4.0f, 1.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("handletop", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171480_().m_171481_(-1.0f, 18.0f, -4.0f, 2.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("handlebottom", CubeListBuilder.m_171558_().m_171514_(26, 2).m_171480_().m_171481_(-1.0f, 21.0f, -4.0f, 2.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("handle", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171480_().m_171481_(-1.0f, 19.0f, -5.0f, 2.0f, 2.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)32);
    }

    public Iterable<ModelPart> getMugParts() {
        return ImmutableList.of((Object)this.base, (Object)this.wall1, (Object)this.wall2, (Object)this.wall3, (Object)this.wall4, (Object)this.handletop, (Object)this.handlebottom, (Object)this.handle);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.getMugParts().forEach(part -> part.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
        if (this.renderLiquid) {
            float r = (float)(this.liquidColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(this.liquidColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(this.liquidColor & 0xFF) / 255.0f;
            this.liquid.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red * r, green * g, blue * b, alpha);
        }
    }
}

