/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.scuba;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaData;
import org.apache.commons.lang3.time.DurationFormatUtils;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScubaHUD {
    @SubscribeEvent
    public static void renderHUD(RenderGameOverlayEvent event) {
        Player player;
        ItemStack chestStack;
        Item chestItem;
        Entity renderViewEntity = Minecraft.m_91087_().f_91075_;
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && renderViewEntity instanceof Player && (chestItem = (chestStack = (player = (Player)renderViewEntity).m_6844_(EquipmentSlot.CHEST)).m_41720_()) instanceof ScubaArmorItem) {
            LazyOptional data = player.getCapability(ScubaData.CAPABILITY);
            int airRemaining = ((ScubaArmorItem)chestItem).getRemainingAir(chestStack);
            ChatFormatting airColor = ScubaHUD.getAirTimeColor(airRemaining, player.f_19853_);
            double depth = ScubaData.getDepth(player);
            String depthStr = depth > 0.0 ? String.format("%.1fm", depth) : TropicraftLangKeys.NA.getLocalizedText();
            data.ifPresent(d -> ScubaHUD.drawHUDStrings(event.getMatrixStack(), new Component[]{TropicraftLangKeys.SCUBA_AIR_TIME.format(String.valueOf(airColor) + ScubaHUD.formatTime(airRemaining)), TropicraftLangKeys.SCUBA_DIVE_TIME.format(ScubaHUD.formatTime(d.getDiveTime())), TropicraftLangKeys.SCUBA_DEPTH.format(depthStr), TropicraftLangKeys.SCUBA_MAX_DEPTH.format(String.format("%.1fm", d.getMaxDepth()))}));
        }
    }

    public static String formatTime(long time) {
        return DurationFormatUtils.formatDuration((long)(time * 50L), (String)"HH:mm:ss");
    }

    public static ChatFormatting getAirTimeColor(int airRemaining, @Nullable Level world) {
        if (airRemaining < 1200) {
            int speed = airRemaining < 200 ? 5 : 10;
            return world != null && world.m_46467_() / (long)speed % 4L == 0L ? ChatFormatting.WHITE : ChatFormatting.RED;
        }
        if (airRemaining < 6000) {
            return ChatFormatting.GOLD;
        }
        return ChatFormatting.GREEN;
    }

    private static void drawHUDStrings(PoseStack matrixStack, Component ... components) {
        Font fr = Minecraft.m_91087_().f_91062_;
        Window mw = Minecraft.m_91087_().m_91268_();
        int n = mw.m_85446_() - 5;
        Objects.requireNonNull(fr);
        int startY = n - 9 * components.length;
        int startX = mw.m_85445_() - 5;
        for (Component text : components) {
            String s = text.getString();
            fr.m_92750_(matrixStack, s, (float)(startX - fr.m_92895_(s)), (float)startY, -1);
            Objects.requireNonNull(fr);
            startY += 9;
        }
    }
}

