/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.block.Block;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.client.entity.model.EIHMachineModel;
import net.tropicraft.core.client.scuba.ModelScubaGear;
import net.tropicraft.core.client.tileentity.MachineRenderer;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.tileentity.AirCompressorBlockEntity;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;

public class AirCompressorRenderer
extends MachineRenderer<AirCompressorBlockEntity> {
    private final ModelScubaGear tankModel;

    public AirCompressorRenderer(BlockEntityRendererProvider.Context context) {
        super(context, (Block)TropicraftBlocks.AIR_COMPRESSOR.get(), new EIHMachineModel(Minecraft.m_91087_().m_167973_().m_171103_(TropicraftRenderLayers.AIRCOMPRESSOR_LAYER)));
        this.tankModel = new ModelScubaGear(context.m_173582_(TropicraftRenderLayers.CHEST_SCUBA_LAYER), EquipmentSlot.CHEST);
    }

    @Override
    protected Material getMaterial() {
        return TropicraftRenderUtils.getTEMaterial("drink_mixer");
    }

    @Override
    protected void animationTransform(AirCompressorBlockEntity te, PoseStack stack, float partialTicks) {
        float progress = te.getBreatheProgress(partialTicks);
        float sin = 1.0f + Mth.m_14089_((float)progress);
        float sc = 1.0f + 0.05f * sin;
        stack.m_85837_(0.0, 1.5, 0.0);
        stack.m_85841_(sc, sc, sc);
        stack.m_85837_(0.0, -1.5, 0.0);
        if ((double)progress < Math.PI) {
            float shake = Mth.m_14031_((float)(te.getBreatheProgress(partialTicks) * 10.0f)) * 8.0f;
            stack.m_85845_(Vector3f.f_122225_.m_122240_(shake));
        }
    }

    @Override
    protected void renderIngredients(AirCompressorBlockEntity te, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.isActive()) {
            stack.m_85836_();
            stack.m_85837_(-0.5, 0.5, 0.0);
            stack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            VertexConsumer builder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)RenderType.m_110458_((ResourceLocation)ScubaArmorItem.getArmorTexture(te.getTank().getType())), (boolean)true, (boolean)false);
            this.tankModel.showChest = true;
            this.tankModel.renderScubaGear(stack, builder, combinedLightIn, combinedOverlayIn, false);
            stack.m_85849_();
        }
    }
}

