/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.tileentity.DrinkMixerBlockEntity;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.item.TropicraftItems;

public class DrinkMixerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public DrinkMixerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return DrinkMixerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TropicraftBlocks.DRINK_MIXER_ENTITY.get()), DrinkMixerBlockEntity::mixTick);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, world, tooltip, flag);
        tooltip.add((Component)new TranslatableComponent(this.m_7705_() + ".desc").m_130940_(ChatFormatting.GRAY));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21205_();
        DrinkMixerBlockEntity mixer = (DrinkMixerBlockEntity)world.m_7702_(pos);
        if (mixer == null) {
            return InteractionResult.FAIL;
        }
        if (mixer.isDoneMixing()) {
            mixer.retrieveResult(player);
            return InteractionResult.CONSUME;
        }
        if (stack.m_41619_()) {
            mixer.emptyMixer(player);
            return InteractionResult.CONSUME;
        }
        ItemStack ingredientStack = stack.m_41777_();
        ingredientStack.m_41764_(1);
        if (mixer.addToMixer(ingredientStack) && !player.m_7500_()) {
            player.m_150109_().m_7407_(player.m_150109_().f_35977_, 1);
        }
        if (ingredientStack.m_41720_() == TropicraftItems.BAMBOO_MUG.get() && mixer.canMix()) {
            mixer.startMixing();
            if (!player.m_7500_()) {
                player.m_150109_().m_7407_(player.m_150109_().f_35977_, 1);
            }
            Drink craftedDrink = MixerRecipes.getDrink(mixer.ingredients);
            Drink pinaColada = Drink.PINA_COLADA;
            if (craftedDrink == null || craftedDrink.drinkId == pinaColada.drinkId) {
                // empty if block
            }
        }
        return InteractionResult.CONSUME;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState ret = super.m_5573_(context);
        return (BlockState)ret.m_61124_((Property)FACING, (Comparable)context.m_43723_().m_6350_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DrinkMixerBlockEntity((BlockEntityType<DrinkMixerBlockEntity>)((BlockEntityType)TropicraftBlocks.DRINK_MIXER_ENTITY.get()), pos, state);
    }
}

