/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.tterrag.registrate.util.entry.RegistryEntry;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.tropicraft.core.common.block.huge_plant.HugePlantBlock;

public final class GrowableDoublePlantBlock
extends DoublePlantBlock
implements BonemealableBlock {
    private final Supplier<RegistryEntry<HugePlantBlock>> growInto;
    private Supplier<RegistryEntry<? extends ItemLike>> pickItem;

    public GrowableDoublePlantBlock(BlockBehaviour.Properties properties, Supplier<RegistryEntry<HugePlantBlock>> growInto) {
        super(properties);
        this.growInto = growInto;
    }

    public GrowableDoublePlantBlock setPickItem(Supplier<RegistryEntry<? extends ItemLike>> item) {
        this.pickItem = item;
        return this;
    }

    public boolean m_7370_(BlockGetter world, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_5491_(Level world, Random random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_7719_(ServerLevel world, Random random, BlockPos pos, BlockState state) {
        BlockPos lowerPos = state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_();
        HugePlantBlock growBlock = (HugePlantBlock)this.growInto.get().get();
        BlockState growState = growBlock.m_49966_();
        if (growState.m_60710_((LevelReader)world, lowerPos)) {
            growBlock.placeAt((LevelAccessor)world, lowerPos, 2);
        }
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
            return super.m_7381_(state, builder);
        }
        return Collections.emptyList();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        if (this.pickItem != null) {
            return new ItemStack((ItemLike)this.pickItem.get().get());
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }
}

