/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import net.tropicraft.core.common.block.TropicraftBlocks;

public class PineappleBlock
extends TallFlowerBlock
implements BonemealableBlock,
IPlantable {
    public static final int TOTAL_GROW_TICKS = 7;
    public static final IntegerProperty STAGE = BlockStateProperties.f_61409_;

    public PineappleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52858_, STAGE});
    }

    public boolean m_7370_(BlockGetter world, BlockPos pos, BlockState blockState, boolean b) {
        return blockState.m_60734_() == TropicraftBlocks.PINEAPPLE.get() && blockState.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER && world.m_8055_(pos.m_7494_()).m_60795_();
    }

    public boolean m_5491_(Level world, Random random, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void m_7719_(ServerLevel world, Random random, BlockPos pos, BlockState state) {
        int currentStage = (Integer)state.m_61143_((Property)STAGE);
        if (currentStage < 7) {
            BlockState growthState = (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(currentStage + 1));
            world.m_7731_(pos, growthState, 4);
        } else {
            BlockState above = world.m_8055_(pos.m_7494_());
            if (above.m_60734_() == this) {
                return;
            }
            if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
                return;
            }
            BlockState fullGrowth = (BlockState)state.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER);
            world.m_7731_(pos.m_7494_(), fullGrowth, 3);
        }
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (pos.m_123342_() > world.m_151558_() - 2) {
            return;
        }
        int growth = (Integer)state.m_61143_((Property)STAGE);
        if (state.m_60734_() == this && growth <= 7 && world.m_46859_(pos.m_7494_()) && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
            if (growth >= 6) {
                BlockState growthState = (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(7));
                world.m_7731_(pos, growthState, 7);
                BlockState fullGrowth = (BlockState)growthState.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER);
                world.m_7731_(pos.m_7494_(), fullGrowth, 3);
            } else {
                BlockState growthState = (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(growth + 1));
                world.m_7731_(pos, growthState, 7);
            }
        }
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
            super.m_5707_(worldIn, pos, state, player);
        } else {
            worldIn.m_5898_(player, 2001, pos, PineappleBlock.m_49956_((BlockState)state));
            PineappleBlock.m_49881_((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (this.m_7898_(stateIn, (LevelReader)worldIn, currentPos)) {
            return stateIn;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
            return worldIn.m_8055_(pos.m_7495_()).m_60734_() == TropicraftBlocks.PINEAPPLE.get();
        }
        return this.canPlaceBlockAt(worldIn, pos);
    }

    private boolean canPlaceBlockAt(LevelReader worldIn, BlockPos pos) {
        BlockState belowState = worldIn.m_8055_(pos.m_7495_());
        return belowState.m_60734_().canSustainPlant(belowState, (BlockGetter)worldIn, pos.m_7495_(), Direction.UP, (IPlantable)this);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }
}

