/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.WaterloggableSaplingBlock;

public final class PropaguleBlock
extends WaterloggableSaplingBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final int GROW_CHANCE = 7;
    public static final BooleanProperty PLANTED = BooleanProperty.m_61465_((String)"planted");

    public PropaguleBlock(AbstractTreeGrower tree, BlockBehaviour.Properties properties) {
        super(tree, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_55973_, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PLANTED, (Comparable)Boolean.valueOf(true)));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TranslatableComponent(this.m_7705_() + ".desc").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)PLANTED)).booleanValue()) {
            BlockPos groundPos = pos.m_7495_();
            return this.m_6266_(world.m_8055_(groundPos), (BlockGetter)world, groundPos);
        }
        BlockPos topPos = pos.m_7494_();
        return world.m_8055_(topPos).m_204336_(BlockTags.f_13035_);
    }

    protected boolean m_6266_(BlockState state, BlockGetter world, BlockPos pos) {
        return super.m_6266_(state, world, pos) || state.m_204336_(BlockTags.f_13029_) || state.m_204336_(TropicraftTags.Blocks.MUD);
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)PLANTED);
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (!world.isAreaLoaded(pos, 1)) {
            return;
        }
        if (world.m_46803_(pos.m_7494_()) >= 9 && random.nextInt(7) == 0) {
            this.m_55980_(world, pos, state, random);
        }
    }

    public boolean m_7370_(BlockGetter world, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)state.m_61143_((Property)PLANTED);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)PLANTED, (Comparable)Boolean.valueOf(context.m_43719_() != Direction.DOWN));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PLANTED});
    }
}

