/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.tropicraft.Constants;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.common.network.TropicraftPackets;
import net.tropicraft.core.common.network.message.MessageSifterInventory;
import net.tropicraft.core.common.network.message.MessageSifterStart;

public class SifterBlockEntity
extends BlockEntity {
    private static final int SIFT_TIME = 80;
    private boolean isSifting;
    private int currentSiftTime = 80;
    private Random rand;
    public double yaw;
    public double yaw2 = 0.0;
    @Nonnull
    private ItemStack siftItem = ItemStack.f_41583_;

    public SifterBlockEntity(BlockEntityType<SifterBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.rand = new Random();
    }

    @Nonnull
    public ItemStack getSiftItem() {
        return this.siftItem;
    }

    public static void siftTick(Level level, BlockPos pos, BlockState state, SifterBlockEntity sifter) {
        sifter.tick();
    }

    private void tick() {
        if (this.currentSiftTime > 0 && this.isSifting) {
            --this.currentSiftTime;
        }
        if (this.f_58857_.f_46443_) {
            this.yaw2 = this.yaw % 360.0;
            this.yaw += 4.545454502105713;
        }
        if (this.isSifting && this.currentSiftTime <= 0) {
            this.stopSifting();
        }
    }

    public void dumpResults(BlockPos pos) {
        this.dumpBeachResults(pos);
        this.syncInventory();
    }

    private void dumpBeachResults(BlockPos pos) {
        int dumpCount = this.rand.nextInt(3) + 1;
        while (dumpCount > 0) {
            ItemStack stack;
            --dumpCount;
            if (this.rand.nextInt(10) == 0) {
                stack = this.getRareItem();
            } else if (this.rand.nextInt(10) < 3) {
                String name = this.rand.nextBoolean() ? Constants.LT17_NAMES[this.rand.nextInt(Constants.LT17_NAMES.length)] : Constants.LT18_NAMES[this.rand.nextInt(Constants.LT18_NAMES.length)];
                CompoundTag nameTag = new CompoundTag();
                nameTag.m_128359_("Name", name);
                stack = new ItemStack((ItemLike)TropicraftItems.LOVE_TROPICS_SHELL.get());
                stack.m_41751_(nameTag);
            } else {
                stack = this.getCommonItem();
            }
            this.spawnItem(stack, pos);
        }
    }

    private void spawnItem(ItemStack stack, BlockPos pos) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
        this.f_58857_.m_7967_((Entity)itemEntity);
    }

    private ItemStack getCommonItem() {
        HolderSet.Named tag = Registry.f_122827_.m_203561_(TropicraftTags.Items.SHELLS);
        int shellIndex = this.rand.nextInt(tag.m_203632_() + 1) - 1;
        if (shellIndex < 0) {
            return this.getRareItem();
        }
        return new ItemStack((ItemLike)((Holder)tag.m_203450_(this.rand).get()).m_203334_());
    }

    private ItemStack getRareItem() {
        int dmg = this.rand.nextInt(12);
        switch (dmg) {
            case 1: {
                return new ItemStack((ItemLike)Items.f_42587_, 1);
            }
            case 2: {
                return new ItemStack((ItemLike)Items.f_42446_, 1);
            }
            case 3: {
                return new ItemStack((ItemLike)Items.f_42421_, 1);
            }
            case 4: {
                return new ItemStack((ItemLike)Items.f_42590_, 1);
            }
            case 5: {
                return new ItemStack((ItemLike)TropicraftItems.WHITE_PEARL.get(), 1);
            }
            case 6: {
                return new ItemStack((ItemLike)TropicraftItems.BLACK_PEARL.get(), 1);
            }
            case 7: {
                return new ItemStack((ItemLike)Items.f_42426_, 1);
            }
        }
        return new ItemStack((ItemLike)TropicraftItems.RUBE_NAUTILUS.get());
    }

    public void addItemToSifter(ItemStack stack) {
        this.siftItem = stack.m_41777_().m_41620_(1);
        this.syncInventory();
    }

    public void startSifting() {
        this.isSifting = true;
        this.currentSiftTime = 80;
        if (!this.f_58857_.f_46443_) {
            TropicraftPackets.sendToDimension(new MessageSifterStart(this), this.f_58857_);
        }
    }

    private void stopSifting() {
        double x = (double)this.f_58858_.m_123341_() + this.f_58857_.f_46441_.nextDouble() * 1.4;
        double y = (double)this.f_58858_.m_123342_() + this.f_58857_.f_46441_.nextDouble() * 1.4;
        double z = (double)this.f_58858_.m_123343_() + this.f_58857_.f_46441_.nextDouble() * 1.4;
        if (!this.f_58857_.f_46443_) {
            this.dumpResults(new BlockPos(x, y, z));
        }
        this.currentSiftTime = 80;
        this.isSifting = false;
        this.siftItem = ItemStack.f_41583_;
        this.syncInventory();
    }

    public void setSifting(boolean flag) {
        this.isSifting = flag;
    }

    public boolean isSifting() {
        return this.isSifting;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.isSifting = nbt.m_128471_("isSifting");
        this.currentSiftTime = nbt.m_128451_("currentSiftTime");
        if (nbt.m_128425_("Item", 10)) {
            this.siftItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Item"));
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("isSifting", this.isSifting);
        nbt.m_128405_("currentSiftTime", this.currentSiftTime);
        if (!this.siftItem.m_41619_()) {
            nbt.m_128365_("Item", (Tag)this.siftItem.m_41739_(new CompoundTag()));
        }
    }

    public CompoundTag getTagCompound(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        return stack.m_41783_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    protected void syncInventory() {
        if (!this.f_58857_.m_5776_()) {
            TropicraftPackets.sendToDimension(new MessageSifterInventory(this), this.f_58857_);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private CompoundTag writeItems(CompoundTag nbt) {
        this.m_183515_(nbt);
        return nbt;
    }

    public void setSiftItem(ItemStack siftItem) {
        this.siftItem = siftItem.m_41777_().m_41620_(1);
    }
}

