/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension;

import com.google.common.collect.ImmutableList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.tropicraft.core.common.block.BlockTropicraftSand;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;

public final class TropicraftSurfaces {
    private static final SurfaceRules.RuleSource BEDROCK = TropicraftSurfaces.makeStateRule(Blocks.f_50752_);
    private static final SurfaceRules.RuleSource DEEPSLATE = TropicraftSurfaces.makeStateRule(Blocks.f_152550_);
    private static final SurfaceRules.RuleSource DIRT = TropicraftSurfaces.makeStateRule(Blocks.f_50493_);
    private static final SurfaceRules.RuleSource GRASS_BLOCK = TropicraftSurfaces.makeStateRule(Blocks.f_50440_);
    private static final SurfaceRules.RuleSource WATER = TropicraftSurfaces.makeStateRule(Blocks.f_49990_);
    private static final SurfaceRules.RuleSource STONE = TropicraftSurfaces.makeStateRule(Blocks.f_50069_);
    private static final SurfaceRules.RuleSource PURIFIED_SAND = TropicraftSurfaces.makeStateRule((Block)TropicraftBlocks.PURIFIED_SAND.get());
    private static final SurfaceRules.RuleSource UNDERWATER_PURIFIED_SAND = TropicraftSurfaces.makeStateRule((BlockState)((BlockTropicraftSand)TropicraftBlocks.PURIFIED_SAND.get()).m_49966_().m_61124_((Property)BlockTropicraftSand.UNDERWATER, (Comparable)Boolean.valueOf(true)));
    private static final SurfaceRules.RuleSource MUD = TropicraftSurfaces.makeStateRule((Block)TropicraftBlocks.MUD.get());

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.m_189390_((BlockState)block.m_49966_());
    }

    private static SurfaceRules.RuleSource makeStateRule(BlockState state) {
        return SurfaceRules.m_189390_((BlockState)state);
    }

    public static SurfaceRules.RuleSource tropics() {
        SurfaceRules.ConditionSource atOrAboveSeaLevel = SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158922_((int)126), (int)0);
        SurfaceRules.ConditionSource aboveSeaLevel = SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158922_((int)127), (int)0);
        SurfaceRules.ConditionSource notUnderWater = SurfaceRules.m_189382_((int)-1, (int)0);
        SurfaceRules.ConditionSource isMangrovey = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{TropicraftBiomes.MANGROVES.getKey(), TropicraftBiomes.OVERGROWN_MANGROVES.getKey()});
        SurfaceRules.ConditionSource notUnderDeepWater = SurfaceRules.m_189419_((int)-6, (int)-1);
        SurfaceRules.RuleSource grassRule = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)notUnderWater, (SurfaceRules.RuleSource)GRASS_BLOCK), DIRT});
        SurfaceRules.RuleSource sandRule = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)notUnderWater), (SurfaceRules.RuleSource)UNDERWATER_PURIFIED_SAND), PURIFIED_SAND});
        SurfaceRules.ConditionSource isSandy = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{TropicraftBiomes.OCEAN.getKey(), TropicraftBiomes.KELP_FOREST.getKey(), TropicraftBiomes.RIVER.getKey(), TropicraftBiomes.BEACH.getKey()});
        SurfaceRules.ConditionSource isStony = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{TropicraftBiomes.TROPICAL_PEAKS.getKey()});
        SurfaceRules.RuleSource surfaceRule = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isMangrovey, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189266_, (double)-0.0125, (double)0.0125), (SurfaceRules.RuleSource)MUD)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isMangrovey, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)TropicraftSurfaces.surfaceNoiseAbove(2.25), (SurfaceRules.RuleSource)MUD)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{TropicraftBiomes.TROPICS.getKey()}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)TropicraftSurfaces.surfaceNoiseAbove(1.35), (SurfaceRules.RuleSource)sandRule)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isSandy, (SurfaceRules.RuleSource)sandRule), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isStony, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189381_(), (SurfaceRules.RuleSource)STONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189266_, (double)-0.0125, (double)0.0125), (SurfaceRules.RuleSource)STONE)}))});
        SurfaceRules.RuleSource underFloorRule = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{surfaceRule, DIRT});
        SurfaceRules.RuleSource floorRule = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{surfaceRule, grassRule});
        SurfaceRules.RuleSource aboveSurface = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isMangrovey, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)atOrAboveSeaLevel, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)aboveSeaLevel), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189409_((ResourceKey)Noises.f_189265_, (double)0.0), (SurfaceRules.RuleSource)WATER)))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)notUnderWater, (SurfaceRules.RuleSource)floorRule)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)notUnderDeepWater, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)underFloorRule)})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)sandRule)});
        ImmutableList.Builder rules = ImmutableList.builder();
        rules.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)5)), (SurfaceRules.RuleSource)BEDROCK));
        rules.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)aboveSurface));
        rules.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"deepslate", (VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)8)), (SurfaceRules.RuleSource)DEEPSLATE));
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])rules.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    private static SurfaceRules.ConditionSource surfaceNoiseAbove(double threshold) {
        return SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)(threshold / 8.25), (double)Double.MAX_VALUE);
    }
}

