/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.tropicraft.core.common.block.BlockTropicraftSand;
import net.tropicraft.core.common.block.TikiTorchBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TropicsTeleporter
implements ITeleporter {
    private static final Logger LOGGER = LogManager.getLogger((String)"tropics portal");
    private static final Block PORTAL_WALL_BLOCK = Blocks.f_50062_;
    private static final Block PORTAL_BLOCK = (Block)TropicraftBlocks.PORTAL_WATER.get();
    private static final Block TELEPORTER_BLOCK = (Block)TropicraftBlocks.TELEPORT_WATER.get();
    private final ServerLevel world;
    private final Long2ObjectMap<PortalPosition> destinationCoordinateCache = new Long2ObjectOpenHashMap(4096);

    public TropicsTeleporter(ServerLevel world) {
        this.world = world;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        long startTime = System.currentTimeMillis();
        PortalInfo portalInfo = this.placeInExistingPortal(entity);
        if (portalInfo == null) {
            this.makePortal(entity);
            long finishTime = System.currentTimeMillis();
            LOGGER.debug("It took {} seconds for TeleporterTropics.placeInPortal to complete", (Object)Float.valueOf((float)(finishTime - startTime) / 1000.0f));
            return this.placeInExistingPortal(entity);
        }
        long finishTime = System.currentTimeMillis();
        LOGGER.debug("It took {} seconds for TeleporterTropics.placeInPortal to complete", (Object)Float.valueOf((float)(finishTime - startTime) / 1000.0f));
        return portalInfo;
    }

    public PortalInfo placeInExistingPortal(Entity entity) {
        int searchArea = 148;
        double closestPortalDistance = -1.0;
        int foundX = 0;
        int foundY = 0;
        int foundZ = 0;
        int entityX = Mth.m_14143_((float)entity.m_20097_().m_123341_());
        int entityZ = Mth.m_14143_((float)entity.m_20097_().m_123343_());
        BlockPos blockpos = BlockPos.f_121853_;
        boolean notInCache = true;
        long queryPos = ChunkPos.m_45589_((int)entityX, (int)entityZ);
        if (this.destinationCoordinateCache.containsKey(queryPos)) {
            PortalPosition portal = (PortalPosition)this.destinationCoordinateCache.get(queryPos);
            closestPortalDistance = 0.0;
            blockpos = portal.pos;
            this.destinationCoordinateCache.put(queryPos, (Object)portal.touch(this.world.m_46467_()));
            notInCache = false;
        } else {
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int x = entityX - searchArea; x <= entityX + searchArea; ++x) {
                double distX = (double)x + 0.5 - (double)entity.m_20097_().m_123341_();
                for (int z = entityZ - searchArea; z <= entityZ + searchArea; ++z) {
                    double distZ = (double)z + 0.5 - (double)entity.m_20097_().m_123343_();
                    for (int y = this.world.m_151558_() - 1; y >= 0; --y) {
                        mutablePos.m_122178_(x, y, z);
                        if (this.world.m_8055_((BlockPos)mutablePos).m_60734_() != PORTAL_BLOCK) continue;
                        mutablePos.m_122173_(Direction.DOWN);
                        while (this.world.m_8055_((BlockPos)mutablePos).m_60734_() == PORTAL_BLOCK) {
                            --y;
                            mutablePos.m_122173_(Direction.DOWN);
                        }
                        double distY = (double)y + 0.5 - (double)mutablePos.m_123342_();
                        double distance = distX * distX + distY * distY + distZ * distZ;
                        if (!(closestPortalDistance < 0.0) && !(distance < closestPortalDistance)) continue;
                        closestPortalDistance = distance;
                        foundX = x;
                        foundY = y;
                        foundZ = z;
                    }
                }
            }
        }
        if (closestPortalDistance >= 0.0) {
            if (notInCache) {
                this.destinationCoordinateCache.put(queryPos, (Object)new PortalPosition(blockpos, this.world.m_46467_()));
            }
            double newLocX = (double)foundX + 0.5;
            double newLocY = (double)foundY + 0.5;
            double newLocZ = (double)foundZ + 0.5;
            BlockPos pos = new BlockPos(foundX, foundY, foundZ);
            if (this.world.m_8055_(pos.m_142125_()).m_60734_() == PORTAL_BLOCK) {
                newLocX -= 0.5;
            }
            if (this.world.m_8055_(pos.m_142126_()).m_60734_() == PORTAL_BLOCK) {
                newLocX += 0.5;
            }
            if (this.world.m_8055_(pos.m_142127_()).m_60734_() == PORTAL_BLOCK) {
                newLocZ -= 0.5;
            }
            if (this.world.m_8055_(pos.m_142128_()).m_60734_() == PORTAL_BLOCK) {
                newLocZ += 0.5;
            }
            return new PortalInfo(new Vec3(newLocX, newLocY + 2.0, newLocZ), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
        }
        return null;
    }

    public boolean makePortal(Entity entity) {
        int searchArea = 16;
        double closestSpot = -1.0;
        int entityX = Mth.m_14107_((double)entity.m_20185_());
        int entityY = Mth.m_14107_((double)entity.m_20186_());
        int entityZ = Mth.m_14107_((double)entity.m_20189_());
        int foundX = entityX;
        int foundY = entityY;
        int foundZ = entityZ;
        for (int x = entityX - searchArea; x <= entityX + searchArea; ++x) {
            double distX = (double)x + 0.5 - entity.m_20185_();
            block1: for (int z = entityZ - searchArea; z <= entityZ + searchArea; ++z) {
                double distZ = (double)z + 0.5 - entity.m_20189_();
                int y = this.world.m_151558_() - 1;
                BlockPos pos = new BlockPos(x, y, z);
                while (!(y < 62 || this.world.m_8055_(pos).m_60734_() != Blocks.f_50016_ && this.getValidBuildBlocks().contains(this.world.m_8055_(pos)))) {
                    y = pos.m_123342_();
                    pos = pos.m_7495_();
                }
                if (y > 83 || y < 63) continue;
                BlockPos tryPos = new BlockPos(x, y, z);
                if (!this.getValidBuildBlocks().contains(this.world.m_8055_(tryPos))) continue;
                for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                    for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                        int otherY = this.world.m_151558_() - 1;
                        BlockPos pos1 = new BlockPos(x + xOffset, otherY, z + zOffset);
                        BlockPos.MutableBlockPos pos2 = tryPos.m_122032_();
                        while (!(otherY < 63 || this.world.m_8055_(pos1).m_60734_() != Blocks.f_50016_ && this.world.m_8055_((BlockPos)pos2).m_60795_())) {
                            otherY = pos1.m_123342_();
                            pos1 = pos1.m_7495_();
                        }
                        if (Math.abs(y - otherY) >= 3) continue block1;
                    }
                }
                double distY = (double)y + 0.5 - entity.m_20186_();
                double distance = distX * distX + distY * distY + distZ * distZ;
                if (!(closestSpot < 0.0) && !(distance < closestSpot)) continue;
                closestSpot = distance;
                foundX = x;
                foundY = y;
                foundZ = z;
            }
        }
        int worldSpawnX = Mth.m_14143_((float)foundX);
        int worldSpawnZ = Mth.m_14143_((float)foundZ);
        int worldSpawnY = this.getTerrainHeightAt(worldSpawnX, worldSpawnZ);
        int SEARCH_FOR_LAND_DISTANCE_MAX = 200;
        if (closestSpot < 0.0) {
            Random r = new Random();
            foundX += r.nextInt(16) - 8;
            foundZ += r.nextInt(16) - 8;
            foundY = worldSpawnY - 2;
            boolean foundLand = false;
            block6: for (int dist = 1; !foundLand && dist < SEARCH_FOR_LAND_DISTANCE_MAX; ++dist) {
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    BlockPos pos = new BlockPos(worldSpawnX, worldSpawnY, worldSpawnZ).m_5484_(dir, 3 + dist);
                    BlockState state = this.world.m_8055_(pos);
                    if (!this.getValidBuildBlocks().contains(state)) continue;
                    foundLand = true;
                    BlockPos buildpos = new BlockPos(worldSpawnX, worldSpawnY + 1, worldSpawnZ).m_5484_(dir, 3);
                    while (!buildpos.equals((Object)pos.m_7494_())) {
                        BlockState thatch = ((RotatedPillarBlock)TropicraftBlocks.THATCH_BUNDLE.get()).m_49966_();
                        this.world.m_46597_(buildpos, thatch);
                        this.world.m_46597_(buildpos.m_142300_(dir.m_122427_()), thatch);
                        this.world.m_46597_(buildpos.m_142300_(dir.m_122428_()), thatch);
                        buildpos = buildpos.m_142300_(dir);
                    }
                    BlockPos stairPosMid = new BlockPos(pos.m_123341_(), worldSpawnY + 1, worldSpawnZ);
                    this.placeStairs(stairPosMid, dir.m_122424_());
                    this.generateThatchBorder(worldSpawnX, worldSpawnY + 1, worldSpawnZ);
                    continue block6;
                }
            }
        }
        this.buildTeleporterAt(worldSpawnX, worldSpawnY + 1, worldSpawnZ);
        return true;
    }

    private void placeStairs(BlockPos pos, Direction dir) {
        if (dir == Direction.EAST || dir == Direction.WEST) {
            BlockPos stairPosLeft = pos.m_142082_(0, 0, -1);
            BlockPos stairPosMid = pos;
            BlockPos stairPosRight = pos.m_142082_(0, 0, 1);
            BlockState thatchStairState = (BlockState)((StairBlock)TropicraftBlocks.THATCH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)dir);
            this.world.m_46597_(stairPosLeft, thatchStairState);
            this.world.m_46597_(stairPosMid, thatchStairState);
            this.world.m_46597_(stairPosRight, thatchStairState);
        } else if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            BlockPos stairPosLeft = pos.m_142082_(-1, 0, 0);
            BlockPos stairPosMid = pos;
            BlockPos stairPosRight = pos.m_142082_(1, 0, 0);
            BlockState thatchStairState = (BlockState)((StairBlock)TropicraftBlocks.THATCH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)dir);
            this.world.m_46597_(stairPosLeft, thatchStairState);
            this.world.m_46597_(stairPosMid, thatchStairState);
            this.world.m_46597_(stairPosRight, thatchStairState);
        }
    }

    private void generateThatchBorder(int x, int y, int z) {
        for (int zOffset = -4; zOffset <= 4; ++zOffset) {
            for (int xOffset = -4; xOffset <= 4; ++xOffset) {
                boolean isWall;
                boolean bl = isWall = xOffset < -2 || xOffset > 2 || zOffset < -2 || zOffset > 2;
                if (!isWall) continue;
                BlockPos thatchPos = new BlockPos(x + xOffset, y, z + zOffset);
                this.world.m_46597_(thatchPos, ((RotatedPillarBlock)TropicraftBlocks.THATCH_BUNDLE.get()).m_49966_());
            }
        }
    }

    public int getTerrainHeightAt(int x, int z) {
        int worldSpawnY;
        LevelChunk chunk2 = this.world.m_6325_(x >> 4, z >> 4);
        for (int y = worldSpawnY = chunk2.m_5885_(Heightmap.Types.WORLD_SURFACE, x & 0xF, z & 0xF); y > 0; --y) {
            BlockState state = this.world.m_8055_(new BlockPos(x, y, z));
            if (!state.m_204336_(BlockTags.f_144274_) && !state.m_204336_(BlockTags.f_13029_) && !state.m_60713_(Blocks.f_49990_) && !state.m_204336_(BlockTags.f_13061_)) continue;
            return y;
        }
        return 0;
    }

    public void buildTeleporterAt(int x, int y, int z) {
        y = Math.max(y, 9);
        for (int yOffset = 4; yOffset >= -7; --yOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                    boolean isCorner;
                    int blockX = x + xOffset;
                    int blockY = y + yOffset;
                    int blockZ = z + zOffset;
                    BlockPos pos = new BlockPos(blockX, blockY, blockZ);
                    if (yOffset == -7) {
                        this.world.m_46597_(pos, PORTAL_WALL_BLOCK.m_49966_());
                    } else if (yOffset > 0) {
                        this.world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    } else {
                        boolean isWall;
                        boolean bl = isWall = xOffset == -2 || xOffset == 2 || zOffset == -2 || zOffset == 2;
                        if (isWall) {
                            this.world.m_46597_(pos, PORTAL_WALL_BLOCK.m_49966_());
                        } else {
                            boolean isTeleportBlock;
                            boolean bl2 = isTeleportBlock = yOffset <= -5;
                            if (isTeleportBlock) {
                                this.world.m_46597_(pos, TELEPORTER_BLOCK.m_49966_());
                            } else {
                                this.world.m_46597_(pos, PORTAL_BLOCK.m_49966_());
                            }
                        }
                    }
                    boolean bl = isCorner = !(xOffset != -2 && xOffset != 2 || zOffset != -2 && zOffset != 2);
                    if (yOffset != 0 || !isCorner) continue;
                    this.world.m_7731_(pos.m_7494_(), (BlockState)((TikiTorchBlock)TropicraftBlocks.TIKI_TORCH.get()).m_49966_().m_61124_(TikiTorchBlock.SECTION, (Comparable)((Object)TikiTorchBlock.TorchSection.LOWER)), 3);
                    this.world.m_7731_(pos.m_6630_(2), (BlockState)((TikiTorchBlock)TropicraftBlocks.TIKI_TORCH.get()).m_49966_().m_61124_(TikiTorchBlock.SECTION, (Comparable)((Object)TikiTorchBlock.TorchSection.MIDDLE)), 3);
                    this.world.m_7731_(pos.m_6630_(3), (BlockState)((TikiTorchBlock)TropicraftBlocks.TIKI_TORCH.get()).m_49966_().m_61124_(TikiTorchBlock.SECTION, (Comparable)((Object)TikiTorchBlock.TorchSection.UPPER)), 3);
                }
            }
        }
    }

    public void tick(long worldTime) {
        if (worldTime % 100L == 0L) {
            this.pruneCoordinateCache(worldTime);
        }
    }

    private void pruneCoordinateCache(long gameTime) {
        long sinceTime = gameTime - 300L;
        ObjectIterator iterator = Long2ObjectMaps.fastIterator(this.destinationCoordinateCache);
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            PortalPosition position = (PortalPosition)entry.getValue();
            if (position.lastUpdateTime >= sinceTime) continue;
            ChunkPos columnPos = new ChunkPos(entry.getLongKey());
            DimensionType dimension = this.world.m_6018_().m_6042_();
            LOGGER.debug("Removing tropics portal ticket for {}:{}", (Object)dimension, (Object)columnPos);
            this.world.m_7726_().registerTickingTicket(TicketType.f_9447_, columnPos, 3, (Object)position.pos);
            iterator.remove();
        }
    }

    private List<BlockState> getValidBuildBlocks() {
        return Arrays.asList(Blocks.f_49992_.m_49966_(), Blocks.f_50034_.m_49966_(), Blocks.f_50493_.m_49966_(), ((BlockTropicraftSand)TropicraftBlocks.PURIFIED_SAND.get()).m_49966_());
    }

    record PortalPosition(BlockPos pos, long lastUpdateTime) {
        public PortalPosition touch(long time) {
            return new PortalPosition(this.pos, time);
        }
    }
}

