/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.biome;

import java.util.function.BiConsumer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;

public class TropicraftBiomeBuilder {
    private final Climate.Parameter islandContinentalness = Climate.Parameter.m_186822_((float)-1.1f, (float)-0.92f);
    private final Climate.Parameter oceanContinentalness = Climate.Parameter.m_186822_((float)-0.92f, (float)-0.19f);
    private final Climate.Parameter landContinentalness = Climate.Parameter.m_186822_((float)-0.1f, (float)1.0f);
    private final Climate.Parameter coastContinentalness = Climate.Parameter.m_186822_((float)-0.19f, (float)-0.1f);
    private final Climate.Parameter inlandContinentalness = Climate.Parameter.m_186822_((float)-0.05f, (float)0.55f);
    private final Climate.Parameter nearInlandContinentalness = Climate.Parameter.m_186822_((float)-0.1f, (float)0.03f);
    private final Climate.Parameter midInlandContinentalness = Climate.Parameter.m_186822_((float)0.03f, (float)0.3f);
    private final Climate.Parameter farInlandContinentalness = Climate.Parameter.m_186822_((float)0.3f, (float)1.0f);
    private final Climate.Parameter FULL_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
    private final Climate.Parameter[] temperatures = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.45f), Climate.Parameter.m_186822_((float)-0.45f, (float)-0.15f), Climate.Parameter.m_186822_((float)-0.15f, (float)0.2f), Climate.Parameter.m_186822_((float)0.2f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private final Climate.Parameter[] humidities = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.35f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.1f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.1f), Climate.Parameter.m_186822_((float)0.1f, (float)0.3f), Climate.Parameter.m_186822_((float)0.3f, (float)1.0f)};
    private final Climate.Parameter[] erosions = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.78f), Climate.Parameter.m_186822_((float)-0.78f, (float)-0.375f), Climate.Parameter.m_186822_((float)-0.375f, (float)-0.2225f), Climate.Parameter.m_186822_((float)-0.2225f, (float)0.05f), Climate.Parameter.m_186822_((float)0.05f, (float)0.45f), Climate.Parameter.m_186822_((float)0.45f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private final Climate.Parameter FROZEN_RANGE = this.temperatures[0];
    private final Climate.Parameter UNFROZEN_RANGE = Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[4]);
    private final Climate.Parameter WET = Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[2], (Climate.Parameter)this.humidities[4]);
    private final Climate.Parameter LESS_WET = Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[0], (Climate.Parameter)this.humidities[1]);
    private final Climate.Parameter MED_WET = Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[2], (Climate.Parameter)this.humidities[3]);
    private final Climate.Parameter MOST_WET = Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[3], (Climate.Parameter)this.humidities[4]);

    public void addBiomes(BiConsumer<Climate.ParameterPoint, RegistryObject<Biome>> consumer) {
        this.addInlandBiomes(consumer);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.LESS_WET, (Climate.Parameter)this.humidities[2]), this.oceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, TropicraftBiomes.OCEAN);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.MOST_WET, this.oceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, TropicraftBiomes.KELP_FOREST);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, this.islandContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, TropicraftBiomes.RAINFOREST);
    }

    private void addInlandBiomes(BiConsumer<Climate.ParameterPoint, RegistryObject<Biome>> consumer) {
        this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(consumer, Climate.Parameter.m_186822_((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(consumer, Climate.Parameter.m_186822_((float)-0.26666668f, (float)-0.05f));
        this.addValleys(consumer, Climate.Parameter.m_186822_((float)-0.05f, (float)0.05f));
        this.addLowSlice(consumer, Climate.Parameter.m_186822_((float)0.05f, (float)0.26666668f));
        this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)0.26666668f, (float)0.4f));
        this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)0.4f, (float)0.56666666f));
        this.addPeaks(consumer, Climate.Parameter.m_186822_((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(consumer, Climate.Parameter.m_186822_((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(consumer, Climate.Parameter.m_186822_((float)0.93333334f, (float)1.0f));
    }

    private void addValleys(BiConsumer<Climate.ParameterPoint, RegistryObject<Biome>> consumer, Climate.Parameter weirdness) {
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, TropicraftBiomes.RIVER);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[3], (Climate.Parameter)this.humidities[4]), this.landContinentalness, this.erosions[6], weirdness, 0.0f, TropicraftBiomes.MANGROVES);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[3], (Climate.Parameter)this.humidities[4]), this.landContinentalness, this.erosions[4], weirdness, 0.0f, TropicraftBiomes.MANGROVES);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, TropicraftBiomes.RIVER);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[5], (Climate.Parameter)this.erosions[5]), weirdness, 0.0f, TropicraftBiomes.RIVER);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, TropicraftBiomes.RIVER);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.LESS_WET, this.farInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, TropicraftBiomes.TROPICS);
    }

    private void addLowSlice(BiConsumer<Climate.ParameterPoint, RegistryObject<Biome>> consumer, Climate.Parameter weirdness) {
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[4], (Climate.Parameter)this.erosions[6]), weirdness, 0.0f, TropicraftBiomes.BEACH);
        if (weirdness.f_186814_() < 0L) {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[3], (Climate.Parameter)this.humidities[4]), this.landContinentalness, this.erosions[6], weirdness, 0.0f, TropicraftBiomes.OVERGROWN_MANGROVES);
            this.addSurfaceBiome(consumer, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[3], (Climate.Parameter)this.humidities[4]), this.landContinentalness, this.erosions[4], weirdness, 0.0f, TropicraftBiomes.OVERGROWN_MANGROVES);
        } else {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[3], (Climate.Parameter)this.humidities[4]), this.landContinentalness, this.erosions[6], weirdness, 0.0f, TropicraftBiomes.MANGROVES);
            this.addSurfaceBiome(consumer, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.humidities[3], (Climate.Parameter)this.humidities[4]), this.landContinentalness, this.erosions[4], weirdness, 0.0f, TropicraftBiomes.MANGROVES);
        }
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, this.landContinentalness, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.TROPICS);
        if (weirdness.f_186814_() < 0L) {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.WET, this.landContinentalness, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.OSA_RAINFOREST);
        } else {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.WET, this.landContinentalness, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        }
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.LESS_WET, this.landContinentalness, this.erosions[2], weirdness, 0.0f, TropicraftBiomes.TROPICS);
        if (weirdness.f_186814_() < 0L) {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.WET, this.landContinentalness, this.erosions[1], weirdness, 0.0f, TropicraftBiomes.OSA_RAINFOREST);
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.WET, this.landContinentalness, this.erosions[0], weirdness, 0.0f, TropicraftBiomes.OSA_RAINFOREST);
        } else {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.WET, this.landContinentalness, this.erosions[1], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.WET, this.landContinentalness, this.erosions[0], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        }
    }

    private void addMidSlice(BiConsumer<Climate.ParameterPoint, RegistryObject<Biome>> consumer, Climate.Parameter weirdness) {
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[4], (Climate.Parameter)this.erosions[6]), weirdness, 0.0f, TropicraftBiomes.BEACH);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, this.landContinentalness, this.erosions[5], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.WET, this.landContinentalness, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.LESS_WET, this.landContinentalness, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.TROPICS);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, this.landContinentalness, this.erosions[2], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, this.landContinentalness, this.erosions[1], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, this.landContinentalness, this.erosions[0], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
    }

    private void addHighSlice(BiConsumer<Climate.ParameterPoint, RegistryObject<Biome>> consumer, Climate.Parameter weirdness) {
        Climate.Parameter coastInwards = Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness);
        Climate.Parameter midInwards = Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, coastInwards, this.erosions[6], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        if (weirdness.f_186814_() < 0L) {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.WET, coastInwards, this.erosions[5], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        } else {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.WET, coastInwards, this.erosions[5], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
        }
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.LESS_WET, coastInwards, this.erosions[5], weirdness, 0.0f, TropicraftBiomes.TROPICS);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, coastInwards, this.erosions[4], weirdness, 0.0f, TropicraftBiomes.TROPICS);
        if (weirdness.f_186814_() < 0L) {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, midInwards, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, midInwards, this.erosions[2], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, midInwards, this.erosions[1], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, midInwards, this.erosions[0], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        } else {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, midInwards, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, midInwards, this.erosions[2], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, midInwards, this.erosions[1], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, midInwards, this.erosions[0], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
        }
    }

    private void addPeaks(BiConsumer<Climate.ParameterPoint, RegistryObject<Biome>> consumer, Climate.Parameter weirdness) {
        Climate.Parameter coastInwards = Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness);
        Climate.Parameter midInwards = Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, coastInwards, this.erosions[6], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        if (weirdness.f_186814_() < 0L) {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.WET, coastInwards, this.erosions[5], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        } else {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.WET, coastInwards, this.erosions[5], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
        }
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.LESS_WET, coastInwards, this.erosions[5], weirdness, 0.0f, TropicraftBiomes.TROPICS);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, coastInwards, this.erosions[4], weirdness, 0.0f, TropicraftBiomes.TROPICS);
        if (weirdness.f_186814_() < 0L) {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, midInwards, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, midInwards, this.erosions[2], weirdness, 0.0f, TropicraftBiomes.RAINFOREST);
        } else {
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, midInwards, this.erosions[3], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
            this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, midInwards, this.erosions[2], weirdness, 0.0f, TropicraftBiomes.BAMBOO_RAINFOREST);
        }
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, TropicraftBiomes.TROPICAL_PEAKS);
        this.addSurfaceBiome(consumer, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, TropicraftBiomes.TROPICAL_PEAKS);
    }

    private void addSurfaceBiome(BiConsumer<Climate.ParameterPoint, RegistryObject<Biome>> consumer, Climate.Parameter p_187182_, Climate.Parameter p_187183_, Climate.Parameter p_187184_, Climate.Parameter p_187185_, Climate.Parameter p_187186_, float p_187187_, RegistryObject<Biome> p_187188_) {
        consumer.accept(Climate.m_186798_((Climate.Parameter)p_187182_, (Climate.Parameter)p_187183_, (Climate.Parameter)p_187184_, (Climate.Parameter)p_187185_, (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)p_187186_, (float)p_187187_), p_187188_);
        consumer.accept(Climate.m_186798_((Climate.Parameter)p_187182_, (Climate.Parameter)p_187183_, (Climate.Parameter)p_187184_, (Climate.Parameter)p_187185_, (Climate.Parameter)Climate.Parameter.m_186820_((float)1.0f), (Climate.Parameter)p_187186_, (float)p_187187_), p_187188_);
    }

    private void addUndergroundBiome(BiConsumer<Climate.ParameterPoint, RegistryObject<Biome>> consumer, Climate.Parameter p_187202_, Climate.Parameter p_187203_, Climate.Parameter p_187204_, Climate.Parameter p_187205_, Climate.Parameter p_187206_, float p_187207_, RegistryObject<Biome> p_187208_) {
        consumer.accept(Climate.m_186798_((Climate.Parameter)p_187202_, (Climate.Parameter)p_187203_, (Climate.Parameter)p_187204_, (Climate.Parameter)p_187205_, (Climate.Parameter)Climate.Parameter.m_186822_((float)0.2f, (float)0.9f), (Climate.Parameter)p_187206_, (float)p_187207_), p_187208_);
    }

    public String getDebugStringForContinentalness(double p_187190_) {
        double d0 = Climate.m_186779_((float)((float)p_187190_));
        if (d0 < (double)this.islandContinentalness.f_186814_()) {
            return "Islands";
        }
        if (d0 < (double)this.oceanContinentalness.f_186814_()) {
            return "Ocean";
        }
        if (d0 < (double)this.coastContinentalness.f_186814_()) {
            return "Coast";
        }
        if (d0 < (double)this.nearInlandContinentalness.f_186814_()) {
            return "Near inland";
        }
        return d0 < (double)this.midInlandContinentalness.f_186814_() ? "Mid inland" : "Far inland";
    }

    public String getDebugStringForErosion(double p_187210_) {
        return TropicraftBiomeBuilder.getDebugStringForNoiseValue(p_187210_, this.erosions);
    }

    public String getDebugStringForTemperature(double p_187221_) {
        return TropicraftBiomeBuilder.getDebugStringForNoiseValue(p_187221_, this.temperatures);
    }

    public String getDebugStringForHumidity(double p_187232_) {
        return TropicraftBiomeBuilder.getDebugStringForNoiseValue(p_187232_, this.humidities);
    }

    private static String getDebugStringForNoiseValue(double p_187158_, Climate.Parameter[] p_187159_) {
        double d0 = Climate.m_186779_((float)((float)p_187158_));
        for (int i = 0; i < p_187159_.length; ++i) {
            if (!(d0 < (double)p_187159_[i].f_186814_())) continue;
            return "" + i;
        }
        return "?";
    }
}

