/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.biome.simulate;

import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.tropicraft.core.common.dimension.TropicraftTerrainShaper;
import net.tropicraft.core.common.dimension.noise.TropicraftNoiseGenSettings;

public class NoiseSimulationHelper {
    private final Climate.Sampler sampler;
    private final TerrainShaper tropics;
    private final NoiseGeneratorSettings noisegen = TropicraftNoiseGenSettings.createNoise(false);
    private final NoiseRouter router;

    public NoiseSimulationHelper(long seed) {
        RegistryAccess.Writable registries = RegistryAccess.m_206197_();
        Registry.m_122965_((Registry)registries.m_175515_(Registry.f_122878_), (ResourceLocation)new ResourceLocation("tropicraft", "tropics"), (Object)this.noisegen);
        this.router = this.noisegen.m_209366_(registries.m_175515_(Registry.f_194568_), seed);
        this.tropics = TropicraftTerrainShaper.tropics();
        this.sampler = new Climate.Sampler(this.router.f_209384_(), this.router.f_209385_(), this.router.f_209386_(), this.router.f_209387_(), this.router.f_209388_(), this.router.f_209389_(), this.router.f_209395_());
    }

    public Climate.TargetPoint sample(int x, int y, int z) {
        return this.sampler.m_183445_(x, y, z);
    }

    public float offset(TerrainShaper.Point p) {
        return this.tropics.m_187311_(p);
    }

    public float factor(TerrainShaper.Point p) {
        return this.tropics.m_187334_(p);
    }

    public TerrainShaper.Point buildPoint(int x, int y, int z) {
        DensityFunction.SinglePointContext ctx = new DensityFunction.SinglePointContext(x, y, z);
        return TerrainShaper.m_187267_((float)((float)this.sampler.f_207847_().m_207386_((DensityFunction.FunctionContext)ctx)), (float)((float)this.sampler.f_207848_().m_207386_((DensityFunction.FunctionContext)ctx)), (float)((float)this.sampler.f_207850_().m_207386_((DensityFunction.FunctionContext)ctx)));
    }

    public double peaksAndValleys(int x, int y, int z) {
        return TropicraftTerrainShaper.peaksAndValleys((float)this.sampler.f_207850_().m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(x, y, z)));
    }

    public double prelimSurfaceLevel(int x, int z) {
        NoiseSettings settings = this.noisegen.f_64439_();
        for (int i = settings.m_189217_() + settings.m_189216_(); i >= settings.m_189217_(); --i) {
            int j = i * settings.m_189212_();
            double d1 = this.router.f_209390_().m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(x, j, z)) + -0.703125;
            double d2 = Mth.m_14008_((double)d1, (double)-64.0, (double)64.0);
            if (!((d2 = NoiseSimulationHelper.applySlide(settings, d2, j)) > 0.390625)) continue;
            return j;
        }
        return 2.147483647E9;
    }

    private static double applySlide(NoiseSettings p_209499_, double p_209500_, double p_209501_) {
        double d0 = (int)p_209501_ / p_209499_.m_189212_() - p_209499_.m_189217_();
        p_209500_ = p_209499_.f_64510_().m_209638_(p_209500_, (double)p_209499_.m_189216_() - d0);
        return p_209499_.f_64511_().m_209638_(p_209500_, d0);
    }
}

