/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.chunk;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.VolcanicSandBlock;
import net.tropicraft.core.common.block.VolcanoBlock;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;
import net.tropicraft.core.common.dimension.chunk.TropicraftChunkGenerator;
import net.tropicraft.core.common.dimension.noise.NoiseModule;
import net.tropicraft.core.common.dimension.noise.generator.Billowed;

@Mod.EventBusSubscriber(modid="tropicraft")
public class VolcanoGenerator {
    public static Set<ResourceLocation> volcanoSpawnBiomesLand = ImmutableSet.of((Object)TropicraftBiomes.TROPICS.getId(), (Object)TropicraftBiomes.RAINFOREST.getId());
    public static Set<ResourceLocation> volcanoSpawnBiomesOcean = ImmutableSet.of((Object)TropicraftBiomes.OCEAN.getId());
    private final long worldSeed;
    private static final int MAX_RADIUS = 65;
    private static final int MIN_RADIUS = 45;
    private static final int CALDERA_CUTOFF = 194;
    public static final int VOLCANO_TOP = 187;
    public static final int VOLCANO_CRUST = 184;
    public static final int LAVA_LEVEL = 149;
    private static final int CRUST_HOLE_CHANCE = 15;
    private static final int OCEAN_HEIGHT_OFFSET = -50;
    public static final int SURFACE_BIOME = 1;
    public static final int OCEAN_BIOME = 2;
    public static final int CHUNK_SIZE_X = 16;
    public static final int CHUNK_SIZE_Z = 16;
    public static final int CHUNK_SIZE_Y = 256;
    private static final int CHUNK_RANGE = 4;
    private static final Supplier<BlockState> VOLCANO_BLOCK = TropicraftBlocks.CHUNK.lazyMap(Block::m_49966_);
    private static final Supplier<BlockState> LAVA_BLOCK = () -> Blocks.f_49991_.m_49966_();
    private static final Supplier<BlockState> SAND_BLOCK = TropicraftBlocks.VOLCANIC_SAND.lazyMap(b -> (BlockState)b.m_49966_().m_61124_((Property)VolcanicSandBlock.HOT, (Comparable)Boolean.valueOf(true)));
    private final BiomeSource biomeSource;
    private final ChunkGenerator chunkGenerator;

    public VolcanoGenerator(long worldSeed, BiomeSource biomeSource, ChunkGenerator chunkGenerator) {
        this.worldSeed = worldSeed;
        this.biomeSource = biomeSource;
        this.chunkGenerator = chunkGenerator;
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().m_129892_().m_82094_();
        LiteralArgumentBuilder locate = (LiteralArgumentBuilder)Commands.m_82127_((String)"locate").requires(source -> source.m_6761_(2));
        dispatcher.register((LiteralArgumentBuilder)locate.then(Commands.m_82127_((String)"tropicraft:volcano").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            BlockPos pos = new BlockPos(source.m_81371_());
            ChunkGenerator generator = source.m_81372_().m_7726_().m_8481_();
            if (!(generator instanceof TropicraftChunkGenerator)) {
                throw new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.locate.failed")).create();
            }
            TropicraftChunkGenerator tropicsGenerator = (TropicraftChunkGenerator)generator;
            VolcanoGenerator volcanoGen = tropicsGenerator.getVolcano();
            BlockPos volcanoPos = volcanoGen.getVolcanoNear(source.m_81372_(), pos.m_123341_() >> 4, pos.m_123343_() >> 4, 100);
            if (volcanoPos == null) {
                throw new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.locate.failed")).create();
            }
            int i = Mth.m_14143_((float)VolcanoGenerator.dist(volcanoPos.m_123341_(), volcanoPos.m_123343_(), pos.m_123341_(), pos.m_123343_()));
            MutableComponent component = ComponentUtils.m_130748_((Component)new TranslatableComponent("chat.coordinates", new Object[]{volcanoPos.m_123341_(), "~", volcanoPos.m_123343_()})).m_130938_(p_207527_ -> p_207527_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + volcanoPos.m_123341_() + " ~ " + volcanoPos.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("chat.coordinates.tooltip"))));
            source.m_81354_((Component)new TranslatableComponent("commands.locate.success", new Object[]{"Volcano", component, i}), false);
            return i;
        })));
    }

    private static float dist(int pX1, int pZ1, int pX2, int pZ2) {
        int i = pX2 - pX1;
        int j = pZ2 - pZ1;
        return Mth.m_14116_((float)(i * i + j * j));
    }

    public ChunkAccess generate(int chunkX, int chunkZ, ChunkAccess chunk, WorldgenRandom random) {
        BlockPos volcanoCoords = this.getVolcanoNear(this.biomeSource, this.worldSeed, chunkX, chunkZ, 0);
        if (volcanoCoords == null) {
            return chunk;
        }
        int HEIGHT_OFFSET = VolcanoGenerator.getHeightOffsetForBiome(volcanoCoords.m_123342_());
        int calderaCutoff = 194 + HEIGHT_OFFSET;
        int lavaLevel = 149 + HEIGHT_OFFSET;
        int volcanoTop = 187 + HEIGHT_OFFSET;
        int volcanoCrust = 184 + HEIGHT_OFFSET;
        chunkX *= 16;
        chunkZ *= 16;
        int volcCenterX = volcanoCoords.m_123341_();
        int volcCenterZ = volcanoCoords.m_123343_();
        long seed = this.getPositionSeed(volcCenterX, volcCenterZ);
        Random rand = new Random(seed);
        int radiusX = rand.nextInt(20) + 45;
        int radiusZ = rand.nextInt(20) + 45;
        NoiseModule volcNoise = this.getNoise(seed);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        if (volcanoCoords.m_123341_() <= chunkX + 15 && volcanoCoords.m_123341_() >= chunkX && volcanoCoords.m_123343_() <= chunkZ + 15 && volcanoCoords.m_123343_() >= chunkZ) {
            BlockPos volcanoBlockPos = new BlockPos(volcanoCoords.m_123341_() & 0xF, 1, volcanoCoords.m_123343_() & 0xF);
            chunk.m_6978_(volcanoBlockPos, ((VolcanoBlock)TropicraftBlocks.VOLCANO.get()).m_49966_(), false);
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int relativeX = x + chunkX - volcCenterX;
                int relativeZ = z + chunkZ - volcCenterZ;
                double volcanoHeight = this.getVolcanoHeight(relativeX, relativeZ, radiusX, radiusZ, volcNoise);
                float distanceSquared = this.getDistanceSq(relativeX, relativeZ, radiusX, radiusZ);
                int groundHeight = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
                groundHeight = Math.min(groundHeight, lavaLevel - 3);
                if (!(distanceSquared < 1.0f)) continue;
                for (int y = 256; y > 0; --y) {
                    pos.m_122178_(x, y, z);
                    if (volcanoHeight + (double)groundHeight < (double)calderaCutoff) {
                        if (volcanoHeight + (double)groundHeight <= (double)volcanoTop) {
                            if (!((double)y <= volcanoHeight + (double)groundHeight)) continue;
                            if (y > groundHeight) {
                                this.placeBlock((BlockPos)pos, VOLCANO_BLOCK, chunk);
                                continue;
                            }
                            if (y <= groundHeight - 2) continue;
                            this.placeBlock((BlockPos)pos, SAND_BLOCK, chunk);
                            continue;
                        }
                        if (y == volcanoCrust - 1) {
                            if (random.nextInt(3) == 0) continue;
                            this.placeBlock((BlockPos)pos, VOLCANO_BLOCK, chunk);
                            continue;
                        }
                        if (y > volcanoTop) continue;
                        this.placeBlock((BlockPos)pos, VOLCANO_BLOCK, chunk);
                        continue;
                    }
                    if (y == volcanoCrust && rand.nextInt(15) != 0) {
                        this.placeBlock((BlockPos)pos, VOLCANO_BLOCK, chunk);
                        continue;
                    }
                    if (y <= lavaLevel) {
                        this.placeBlock((BlockPos)pos, LAVA_BLOCK, chunk);
                        continue;
                    }
                    this.placeBlock((BlockPos)pos, () -> ((Block)Blocks.f_50016_).m_49966_(), chunk);
                }
            }
        }
        return chunk;
    }

    private long getPositionSeed(int volcCenterX, int volcCenterZ) {
        return (long)volcCenterX * 341873128712L + (long)volcCenterZ * 132897987541L + this.worldSeed + 4291726L;
    }

    private NoiseModule getNoise(long seed) {
        Billowed volcNoise = new Billowed(seed, 1, 1.0);
        volcNoise.amplitude = 0.45;
        return volcNoise;
    }

    public int getVolcanoHeight(int groundHeight, int x, int z) {
        BlockPos volcanoCoords = this.getVolcanoNear(this.biomeSource, this.worldSeed, x >> 4, z >> 4, 0);
        if (volcanoCoords == null) {
            return -1;
        }
        int volcCenterX = volcanoCoords.m_123341_();
        int volcCenterZ = volcanoCoords.m_123343_();
        long seed = this.getPositionSeed(volcCenterX, volcCenterZ);
        Random rand = new Random(seed);
        int radiusX = rand.nextInt(20) + 45;
        int radiusZ = rand.nextInt(20) + 45;
        NoiseModule volcNoise = this.getNoise(seed);
        int relativeX = x - volcCenterX;
        int relativeZ = z - volcCenterZ;
        double ret = this.getVolcanoHeight(relativeX, relativeZ, radiusX, radiusZ, volcNoise);
        int heightOffset = VolcanoGenerator.getHeightOffsetForBiome(volcanoCoords.m_123342_());
        int lavaLevel = 149 + heightOffset;
        int volcanoCrust = 184 + heightOffset;
        groundHeight = Math.min(groundHeight, lavaLevel - 3);
        return Math.min(volcanoCrust + 1, Mth.m_14165_((double)(ret + (double)groundHeight)));
    }

    private float getDistanceSq(float relativeX, float relativeZ, float radiusX, float radiusZ) {
        return relativeX / radiusX * (relativeX / radiusX) + relativeZ / radiusZ * (relativeZ / radiusZ);
    }

    private double getVolcanoHeight(float relativeX, float relativeZ, float radiusX, float radiusZ, NoiseModule volcNoise) {
        float distanceSquared = this.getDistanceSq(relativeX, relativeZ, radiusX, radiusZ);
        float perlin = (float)volcNoise.getNoise((double)relativeX * 0.21 + 0.01, (double)relativeZ * 0.21 + 0.01) + 1.0f;
        double steepness = 10.2;
        return steepness / (double)distanceSquared * (double)perlin - steepness - 2.0;
    }

    public void placeBlock(BlockPos pos, Supplier<BlockState> blockState, ChunkAccess chunk) {
        chunk.m_6978_(pos, blockState.get(), false);
    }

    public BlockState getBlockState(BlockPos pos, ChunkAccess chunk) {
        return chunk.m_8055_(pos);
    }

    public int canGenVolcanoAtCoords(BiomeSource biomeSource, long worldSeed, int chunkX, int chunkZ) {
        int numChunks = 64;
        int offsetChunks = 16;
        int oldi = chunkX;
        int oldj = chunkZ;
        if (chunkX < 0) {
            chunkX -= numChunks - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= numChunks - 1;
        }
        int randX = chunkX / numChunks;
        int randZ = chunkZ / numChunks;
        long seed = (long)randX * 341873128712L + (long)randZ * 132897987541L + worldSeed + 4291726L;
        Random rand = new Random(seed);
        randX *= numChunks;
        randZ *= numChunks;
        if (oldi == (randX += rand.nextInt(numChunks - offsetChunks)) && oldj == (randZ += rand.nextInt(numChunks - offsetChunks))) {
            if (this.hasAllBiomes(biomeSource, oldi * 16 + 8, 0, oldj * 16 + 8, volcanoSpawnBiomesLand)) {
                return 1;
            }
            if (this.hasAllBiomes(biomeSource, oldi * 16 + 8, 0, oldj * 16 + 8, volcanoSpawnBiomesOcean)) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public BlockPos getVolcanoNear(ServerLevel world, int chunkX, int chunkZ, int maxRadius) {
        return this.getVolcanoNear(world.m_7726_().m_8481_().m_62218_(), world.m_7328_(), chunkX, chunkZ, maxRadius);
    }

    public BlockPos getVolcanoNear(BiomeSource biomeSource, long worldSeed, int chunkX, int chunkZ, int maxRadius) {
        maxRadius += 4;
        for (int radius = 0; radius <= maxRadius; ++radius) {
            for (int offsetX = -radius; offsetX <= radius; ++offsetX) {
                boolean edgeX = offsetX == -radius || offsetX == radius;
                for (int offsetZ = -radius; offsetZ <= radius; ++offsetZ) {
                    int z;
                    int x;
                    int biome;
                    boolean edgeZ;
                    boolean bl = edgeZ = offsetZ == -radius || offsetZ == radius;
                    if (!edgeX && !edgeZ || (biome = this.canGenVolcanoAtCoords(biomeSource, worldSeed, x = chunkX + offsetX, z = chunkZ + offsetZ)) == 0) continue;
                    return new BlockPos((x << 4) + 8, biome, (z << 4) + 8);
                }
            }
        }
        return null;
    }

    public static int getHeightOffsetForBiome(int biome) {
        return biome == 1 ? 0 : -50;
    }

    private boolean hasAllBiomes(BiomeSource biomeSource, int centerX, int centerY, int centerZ, Set<ResourceLocation> allowedBiomes) {
        Biome biome = (Biome)biomeSource.m_203407_(centerX >> 2, centerY >> 2, centerZ >> 2, this.chunkGenerator.m_183403_()).m_203334_();
        return allowedBiomes.contains(biome.getRegistryName());
    }
}

