/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.tropicraft.core.common.block.TropicraftBlocks;

public class SeagrassFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BiFunction<Boolean, Boolean, SeagrassData> SEAGRASS_DATA = Util.m_143821_((deep, selector) -> {
        if (deep.booleanValue()) {
            return selector != false ? new SeagrassData((Block)TropicraftBlocks.SICKLE_SEAGRASS.get(), (Block)TropicraftBlocks.MATTED_SICKLE_SEAGRASS.get(), (Block)TropicraftBlocks.TALL_SICKLE_SEAGRASS.get()) : new SeagrassData((Block)TropicraftBlocks.NOODLE_SEAGRASS.get(), (Block)TropicraftBlocks.MATTED_NOODLE_SEAGRASS.get(), null);
        }
        return selector != false ? new SeagrassData((Block)TropicraftBlocks.EEL_GRASS.get(), (Block)TropicraftBlocks.MATTED_EEL_GRASS.get(), (Block)TropicraftBlocks.TALL_EEL_GRASS.get(), new SeagrassData((Block)TropicraftBlocks.FLOWERING_EEL_GRASS.get(), (Block)TropicraftBlocks.MATTED_EEL_GRASS.get(), (Block)TropicraftBlocks.FLOWERING_TALL_EEL_GRASS.get())) : new SeagrassData((Block)TropicraftBlocks.FERN_SEAGRASS.get(), (Block)TropicraftBlocks.MATTED_FERN_SEAGRASS.get(), (Block)TropicraftBlocks.TALL_FERN_SEAGRASS.get());
    });

    public SeagrassFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random random = context.m_159776_();
        if (random.nextInt(4) == 0) {
            return false;
        }
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(level.m_7328_()));
        NormalNoise seagrassSelector = NormalNoise.m_164354_((RandomSource)worldgenrandom, (int)-6, (double[])new double[]{1.0});
        int rad = random.nextInt(4) + 8;
        int floorOrigin = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_(), pos.m_123343_());
        int surfaceOrigin = level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_(), pos.m_123343_());
        boolean deep = surfaceOrigin - floorOrigin >= 18;
        for (int x = -rad; x <= rad; ++x) {
            for (int z = -rad; z <= rad; ++z) {
                BlockPos local;
                if (x * x + z * z > rad * rad) continue;
                int floor = level.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, pos.m_123341_() + x, pos.m_123343_() + z);
                int surface = level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_() + x, pos.m_123343_() + z);
                int diff = surface - floor;
                if (diff <= 0) continue;
                boolean selection = seagrassSelector.m_75380_((double)(pos.m_123341_() + x), (double)pos.m_123342_(), (double)(pos.m_123343_() + z)) > 0.0;
                SeagrassData data = SEAGRASS_DATA.apply(deep, selection);
                Block matted = data.matted;
                Block tall = data.tall;
                Block seagrass = data.seagrass;
                SeagrassData flowering = data.flowering;
                if (flowering != null && random.nextInt(8) == 0) {
                    seagrass = flowering.seagrass;
                    tall = flowering.tall;
                }
                if (random.nextInt(8) > 0) {
                    level.m_7731_(pos.m_142082_(x, floor, z).m_175288_(floor - 1), matted.m_49966_(), 2);
                }
                if (!level.m_8055_(local = pos.m_142082_(x, floor, z).m_175288_(floor)).m_60819_().m_205070_(FluidTags.f_13131_)) continue;
                boolean placed = false;
                if (tall != null && random.nextInt(10) == 0 && level.m_8055_(local.m_7494_()).m_60819_().m_205070_(FluidTags.f_13131_)) {
                    level.m_7731_(local.m_7494_(), (BlockState)tall.m_49966_().m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER), 2);
                    level.m_7731_(local, (BlockState)tall.m_49966_().m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER), 2);
                    placed = true;
                }
                if (!placed && random.nextInt(tall == null ? 3 : 8) == 0) {
                    level.m_7731_(local, seagrass.m_49966_(), 2);
                    placed = true;
                }
                if (placed || random.nextInt(80) != 0) continue;
                level.m_7731_(local, (BlockState)Blocks.f_50567_.m_49966_().m_61124_((Property)BlockStateProperties.f_61425_, (Comparable)Integer.valueOf(random.nextInt(4) + 1)), 2);
            }
        }
        return true;
    }

    record SeagrassData(Block seagrass, Block matted, Block tall, SeagrassData flowering) {
        SeagrassData(Block seagrass, Block matted, Block tall) {
            this(seagrass, matted, tall, null);
        }
    }
}

