/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.AquaticFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CarvingMaskPlacement;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatures;
import net.tropicraft.core.common.dimension.feature.TropicraftVegetationFeatures;

public final class TropicraftVegetationPlacements {
    public static final TropicraftFeatures.Register REGISTER = TropicraftFeatures.Register.create();
    public static final RegistryObject<PlacedFeature> VINES_RAINFOREST = REGISTER.placed("rainforest_vines", TropicraftVegetationFeatures.RAINFOREST_VINES, () -> List.of(CountPlacement.m_191628_((int)50), InSquarePlacement.m_191715_()));
    public static final RegistryObject<PlacedFeature> SMALL_GOLDEN_LEATHER_FERN = REGISTER.placed("small_golden_leather_fern", TropicraftVegetationFeatures.SMALL_GOLDEN_LEATHER_FERN, () -> List.of(RarityFilter.m_191900_((int)4), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> TALL_GOLDEN_LEATHER_FERN = REGISTER.placed("tall_golden_leather_fern", TropicraftVegetationFeatures.TALL_GOLDEN_LEATHER_FERN, () -> List.of(RarityFilter.m_191900_((int)8), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> HUGE_GOLDEN_LEATHER_FERN = REGISTER.placed("huge_golden_leather_fern", TropicraftVegetationFeatures.HUGE_GOLDEN_LEATHER_FERN, () -> List.of(RarityFilter.m_191900_((int)12), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> OVERGROWN_SMALL_GOLDEN_LEATHER_FERN = REGISTER.placed("overgrown_small_golden_leather_fern", TropicraftVegetationFeatures.SMALL_GOLDEN_LEATHER_FERN, () -> List.of(RarityFilter.m_191900_((int)2), CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> OVERGROWN_TALL_GOLDEN_LEATHER_FERN = REGISTER.placed("overgrown_tall_golden_leather_fern", TropicraftVegetationFeatures.TALL_GOLDEN_LEATHER_FERN, () -> List.of(RarityFilter.m_191900_((int)2), CountPlacement.m_191628_((int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> OVERGROWN_HUGE_GOLDEN_LEATHER_FERN = REGISTER.placed("overgrown_huge_golden_leather_fern", TropicraftVegetationFeatures.HUGE_GOLDEN_LEATHER_FERN, () -> List.of(RarityFilter.m_191900_((int)90), CountPlacement.m_191628_((int)6), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> TREES_MANGROVE = REGISTER.placed("trees_mangrove", TropicraftVegetationFeatures.TREES_MANGROVE, () -> TropicraftVegetationPlacements.mangrovePlacement(7, 200.0, 1.5));
    public static final RegistryObject<PlacedFeature> TREES_MANGROVE_SPARSE = REGISTER.placed("trees_mangrove_sparse", TropicraftVegetationFeatures.TREES_MANGROVE, () -> TropicraftVegetationPlacements.mangrovePlacement(3, 200.0, 1.0));
    public static final RegistryObject<PlacedFeature> TREES_FRUIT = REGISTER.placed("trees_fruit", TropicraftVegetationFeatures.TREES_FRUIT, () -> REGISTER.sparseTreePlacement(0.1f));
    public static final RegistryObject<PlacedFeature> TREES_PALM = REGISTER.placed("trees_palm", TropicraftVegetationFeatures.TREES_PALM, () -> REGISTER.sparseTreePlacement(0.5f));
    public static final RegistryObject<PlacedFeature> TREES_RAINFOREST = REGISTER.placed("trees_rainforest", TropicraftVegetationFeatures.TREES_RAINFOREST, () -> REGISTER.treePlacement(1, 0.5f, 1));
    public static final RegistryObject<PlacedFeature> TREES_PLEODENDRON = REGISTER.placed("trees_pleodendron", TropicraftVegetationFeatures.TREES_PLEODENDRON, () -> REGISTER.treePlacement(0, 0.1f, 1));
    public static final RegistryObject<PlacedFeature> TREES_PAPAYA = REGISTER.placed("trees_papaya", TropicraftVegetationFeatures.TREES_PAPAYA, () -> REGISTER.treePlacement(0, 0.2f, 1));
    public static final RegistryObject<PlacedFeature> BUSH_FLOWERING_COMMON = REGISTER.placed("bush_flowering_common", TropicraftVegetationFeatures.BUSH_FLOWERING, () -> REGISTER.treePlacement(0, 0.25f, 1));
    public static final RegistryObject<PlacedFeature> BUSH_FLOWERING_RARE = REGISTER.placed("bush_flowering_rare", TropicraftVegetationFeatures.BUSH_FLOWERING, () -> REGISTER.treePlacement(0, 0.125f, 1));
    public static final RegistryObject<PlacedFeature> PATCH_GRASS_TROPICS = REGISTER.placed("tropics_grass", TropicraftVegetationFeatures.PATCH_GRASS_TROPICS, () -> VegetationPlacements.m_195474_((int)10));
    public static final RegistryObject<PlacedFeature> BAMBOO = REGISTER.placed("bamboo", TropicraftVegetationFeatures.BAMBOO, () -> List.of(NoiseBasedCountPlacement.m_191731_((int)50, (double)140.0, (double)0.5), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> TROPI_SEAGRASS = REGISTER.placed("tropi_seagrass", TropicraftVegetationFeatures.TROPI_SEAGRASS, () -> List.of(NoiseBasedCountPlacement.m_191731_((int)1, (double)150.0, (double)0.0), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> PATCH_PINEAPPLE = REGISTER.placed("patch_pineapple", TropicraftVegetationFeatures.PATCH_PINEAPPLE, () -> List.of(RarityFilter.m_191900_((int)6), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> FLOWERS_TROPICS = REGISTER.placed("flowers_tropics", TropicraftVegetationFeatures.FLOWERS_TROPICS, () -> List.of(RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> FLOWERS_RAINFOREST = REGISTER.placed("flowers_rainforest", TropicraftVegetationFeatures.FLOWERS_RAINFOREST, () -> List.of(RarityFilter.m_191900_((int)6), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> PATCH_IRIS = REGISTER.placed("patch_iris", TropicraftVegetationFeatures.PATCH_IRIS, () -> List.of(RarityFilter.m_191900_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> COFFEE_BUSH = REGISTER.placed("coffee_bush", TropicraftVegetationFeatures.COFFEE_BUSH, () -> TropicraftVegetationPlacements.worldSurfaceSquaredWithChance(25));
    public static final RegistryObject<PlacedFeature> UNDERGROWTH = REGISTER.placed("undergrowth", TropicraftVegetationFeatures.UNDERGROWTH, () -> TropicraftVegetationPlacements.worldSurfaceSquaredWithChance(5));
    public static final RegistryObject<PlacedFeature> SINGLE_UNDERGROWTH = REGISTER.placed("single_undergrowth", TropicraftVegetationFeatures.SINGLE_UNDERGROWTH, () -> VegetationPlacements.m_195474_((int)2));
    public static final RegistryObject<PlacedFeature> SEAGRASS = REGISTER.placed("seagrass", TropicraftVegetationFeatures.SEAGRASS, () -> List.of(CountPlacement.m_191628_((int)48), InSquarePlacement.m_191715_(), HeightmapPlacement.m_191702_((Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG)));
    public static final RegistryObject<PlacedFeature> UNDERGROUND_SEAGRASS_ON_STONE = REGISTER.placed("underground_seagrass_on_stone", TropicraftVegetationFeatures.UNDERGROUND_SEAGRASS, () -> TropicraftVegetationPlacements.seagrassPlacement(() -> Blocks.f_50069_));
    public static final RegistryObject<PlacedFeature> UNDERGROUND_SEAGRASS_ON_DIRT = REGISTER.placed("underground_seagrass_on_dirt", TropicraftVegetationFeatures.UNDERGROUND_SEAGRASS, () -> TropicraftVegetationPlacements.seagrassPlacement(() -> Blocks.f_50493_));
    public static final RegistryObject<PlacedFeature> UNDERGROUND_SEA_PICKLES = REGISTER.placed("underground_sea_pickles", TropicraftVegetationFeatures.UNDERGROUND_SEA_PICKLES, () -> List.of(CarvingMaskPlacement.m_191590_((GenerationStep.Carving)GenerationStep.Carving.LIQUID), RarityFilter.m_191900_((int)10), BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> MANGROVE_REEDS = REGISTER.placed("mangrove_reeds", TropicraftVegetationFeatures.MANGROVE_REEDS, () -> List.of(CountPlacement.m_191628_((int)2), InSquarePlacement.m_191715_(), HeightmapPlacement.m_191702_((Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG), BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> KELP = REGISTER.placed("kelp", AquaticFeatures.f_194931_, () -> List.of(NoiseBasedCountPlacement.m_191731_((int)75, (double)80.0, (double)0.55), InSquarePlacement.m_191715_(), PlacementUtils.f_195353_, BiomeFilter.m_191561_()));

    public static List<PlacementModifier> worldSurfaceSquaredWithChance(int onceEvery) {
        return List.of(RarityFilter.m_191900_((int)onceEvery), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> seagrassPlacement(Supplier<? extends Block> belowBlock) {
        BlockPredicateFilter seagrassPredicate = BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190417_((BlockPredicate[])new BlockPredicate[]{BlockPredicate.m_190396_((Block)belowBlock.get(), (Vec3i)new BlockPos(0, -1, 0)), BlockPredicate.m_190396_((Block)Blocks.f_49990_, (Vec3i)BlockPos.f_121853_), BlockPredicate.m_190396_((Block)Blocks.f_49990_, (Vec3i)new BlockPos(0, 1, 0))}));
        return List.of(CarvingMaskPlacement.m_191590_((GenerationStep.Carving)GenerationStep.Carving.LIQUID), RarityFilter.m_191900_((int)10), seagrassPredicate, BiomeFilter.m_191561_());
    }

    public static void addFruitTrees(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TREES_FRUIT);
    }

    public static void addFloweringBushes(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, BUSH_FLOWERING_COMMON);
    }

    public static void addRareFloweringBushes(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, BUSH_FLOWERING_RARE);
    }

    public static void addPalmTrees(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TREES_PALM);
    }

    public static void addRainforestTrees(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TREES_RAINFOREST);
    }

    public static void addRainforestPlants(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, (Holder<PlacedFeature>)VegetationPlacements.f_195463_);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, VINES_RAINFOREST);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, COFFEE_BUSH);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, SINGLE_UNDERGROWTH);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, FLOWERS_RAINFOREST);
    }

    public static void addUndergrowth(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, UNDERGROWTH);
    }

    public static void addMangroveVegetation(BiomeGenerationSettings.Builder generation, boolean sparse) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, sparse ? TREES_MANGROVE_SPARSE : TREES_MANGROVE);
    }

    public static void addOvergrownGoldenLeatherFern(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, OVERGROWN_SMALL_GOLDEN_LEATHER_FERN);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, OVERGROWN_TALL_GOLDEN_LEATHER_FERN);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, OVERGROWN_HUGE_GOLDEN_LEATHER_FERN);
    }

    public static void addGoldenLeatherFern(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, SMALL_GOLDEN_LEATHER_FERN);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TALL_GOLDEN_LEATHER_FERN);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, HUGE_GOLDEN_LEATHER_FERN);
    }

    public static void addPleodendron(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TREES_PLEODENDRON);
    }

    public static void addPapaya(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TREES_PAPAYA);
    }

    public static void addMangroveReeds(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, MANGROVE_REEDS);
    }

    public static void addTropicsGrass(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, PATCH_GRASS_TROPICS);
    }

    public static void addBamboo(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, BAMBOO);
    }

    public static void addPineapples(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, PATCH_PINEAPPLE);
    }

    public static void addTropicsFlowers(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, FLOWERS_TROPICS);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, PATCH_IRIS);
    }

    public static void addUndergroundSeagrass(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, UNDERGROUND_SEAGRASS_ON_STONE);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, UNDERGROUND_SEAGRASS_ON_DIRT);
    }

    public static void addSeagrass(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TROPI_SEAGRASS);
        TropicraftVegetationPlacements.addVegetalDecoration(generation, SEAGRASS);
    }

    public static void addUndergroundPickles(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, UNDERGROUND_SEA_PICKLES);
    }

    public static void addKelp(BiomeGenerationSettings.Builder generation) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, KELP);
    }

    private static void addVegetalDecoration(BiomeGenerationSettings.Builder generation, RegistryObject<PlacedFeature> feature) {
        TropicraftVegetationPlacements.addVegetalDecoration(generation, TropicraftFeatures.holderOf(feature));
    }

    private static void addVegetalDecoration(BiomeGenerationSettings.Builder generation, Holder<PlacedFeature> feature) {
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, feature);
    }

    private static List<PlacementModifier> mangrovePlacement(int noiseToCountRatio, double noiseFactor, double noiseOffset) {
        return List.of(NoiseBasedCountPlacement.m_191731_((int)noiseToCountRatio, (double)noiseFactor, (double)noiseOffset), InSquarePlacement.m_191715_(), HeightmapPlacement.m_191702_((Heightmap.Types)Heightmap.Types.OCEAN_FLOOR), BiomeFilter.m_191561_());
    }
}

