/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.jigsaw.AdjustBuildingHeightProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.AirToCaveAirProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SinkInGroundProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SmoothingGravityProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SteepPathProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.StructureSupportsProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.StructureVoidProcessor;

public final class TropicraftProcessorLists {
    public static final DeferredRegister<StructureProcessorList> REGISTER = DeferredRegister.create((ResourceKey)Registry.f_122883_, (String)"tropicraft");
    private static final StructureSupportsProcessor FENCE_EXTENDER = new StructureSupportsProcessor(false, List.of(TropicraftBlocks.BAMBOO_FENCE.getId()));
    public static final RegistryObject<StructureProcessorList> KOA_TOWN_CENTERS = TropicraftProcessorLists.register("koa_village/town_centers", FENCE_EXTENDER, new StructureVoidProcessor());
    public static final RegistryObject<StructureProcessorList> KOA_BUILDINGS = TropicraftProcessorLists.register("koa_village/buildings", new AdjustBuildingHeightProcessor(126), FENCE_EXTENDER, new StructureVoidProcessor());
    public static final RegistryObject<StructureProcessorList> KOA_PATH = TropicraftProcessorLists.register("koa_village/koa_path", new SmoothingGravityProcessor(Heightmap.Types.WORLD_SURFACE_WG, -1), new SinkInGroundProcessor(), new SteepPathProcessor(), new StructureSupportsProcessor(false, List.of(TropicraftBlocks.BAMBOO_FENCE.getId())));
    public static final RegistryObject<StructureProcessorList> HOME_TREE_BASE = TropicraftProcessorLists.register("home_tree/base", new AirToCaveAirProcessor());
    public static final RegistryObject<StructureProcessorList> HOME_TREE_START = TropicraftProcessorLists.register("home_tree/start", new AirToCaveAirProcessor(), new StructureSupportsProcessor(true, (List<ResourceLocation>)ImmutableList.of((Object)TropicraftBlocks.MAHOGANY_LOG.getId())));

    private static RegistryObject<StructureProcessorList> register(String id, StructureProcessor ... processors) {
        return REGISTER.register(id, () -> new StructureProcessorList(Arrays.asList(processors)));
    }
}

