/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree.mangrove;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTreeDecorators;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.MangroveTrunkPlacer;

public class PneumatophoresTreeDecorator
extends TreeDecorator {
    public static final Codec<PneumatophoresTreeDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122824_.m_194605_().fieldOf("roots_block").forGetter(c -> c.rootsBlock), (App)Codec.INT.fieldOf("min_count").forGetter(c -> c.minCount), (App)Codec.INT.fieldOf("max_count").forGetter(c -> c.maxCount), (App)Codec.INT.fieldOf("spread").forGetter(c -> c.spread)).apply((Applicative)instance, PneumatophoresTreeDecorator::new));
    private final Block rootsBlock;
    private final int minCount;
    private final int maxCount;
    private final int spread;

    public PneumatophoresTreeDecorator(Block rootsBlock, int minCount, int maxCount, int spread) {
        this.rootsBlock = rootsBlock;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.spread = spread;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)TropicraftTreeDecorators.PNEUMATOPHORES.get();
    }

    public void m_142741_(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, Random random, List<BlockPos> pLogPositions, List<BlockPos> pLeafPositions) {
        BlockPos origin = Util.findLowestBlock(pLogPositions);
        if (origin == null) {
            return;
        }
        int spread = this.spread;
        int count = random.nextInt(this.maxCount - this.minCount + 1) + this.minCount;
        int maxTopY = origin.m_123342_() + 3;
        int minBottomY = origin.m_123342_() - 6;
        BlockPos.MutableBlockPos mutablePos = origin.m_122032_();
        while (MangroveTrunkPlacer.isWaterAt(pLevel, (BlockPos)mutablePos) && mutablePos.m_123342_() < maxTopY) {
            mutablePos.m_122173_(Direction.UP);
        }
        int topY = mutablePos.m_123342_();
        for (int i = 0; i < count; ++i) {
            int y;
            int dx = random.nextInt(spread) - random.nextInt(spread);
            int dz = random.nextInt(spread) - random.nextInt(spread);
            if (dx == 0 && dz == 0) continue;
            mutablePos.m_122154_((Vec3i)origin, dx, 0, dz);
            boolean canGenerate = false;
            int minY = minBottomY;
            for (y = topY; y >= minBottomY; --y) {
                mutablePos.m_142448_(y);
                if (TreeFeature.m_67272_((LevelSimulatedReader)pLevel, (BlockPos)mutablePos)) continue;
                canGenerate = true;
                minY = y;
                break;
            }
            if (!canGenerate) continue;
            y = topY;
            while (y >= minY) {
                mutablePos.m_142448_(y--);
                MangroveTrunkPlacer.setRootsAt((LevelSimulatedRW)pLevel, (BlockPos)mutablePos, this.rootsBlock);
            }
        }
    }
}

