/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.noise;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseRouterWithOnlyNoises;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public final class TropicraftNoiseGen {
    private static final ResourceKey<DensityFunction> Y = TropicraftNoiseGen.createKey("y");
    private static final ResourceKey<DensityFunction> SHIFT_X = TropicraftNoiseGen.createKey("shift_x");
    private static final ResourceKey<DensityFunction> SHIFT_Z = TropicraftNoiseGen.createKey("shift_z");
    private static final ResourceKey<DensityFunction> BASE_3D_NOISE = TropicraftNoiseGen.createKey("overworld/base_3d_noise");
    private static final ResourceKey<DensityFunction> CONTINENTS = TropicraftNoiseGen.createKey("overworld/continents");
    private static final ResourceKey<DensityFunction> EROSION = TropicraftNoiseGen.createKey("overworld/erosion");
    private static final ResourceKey<DensityFunction> RIDGES = TropicraftNoiseGen.createKey("overworld/ridges");
    private static final ResourceKey<DensityFunction> FACTOR = TropicraftNoiseGen.createKey("overworld/factor");
    private static final ResourceKey<DensityFunction> DEPTH = TropicraftNoiseGen.createKey("overworld/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE = TropicraftNoiseGen.createKey("overworld/sloped_cheese");
    private static final ResourceKey<DensityFunction> CONTINENTS_LARGE = TropicraftNoiseGen.createKey("overworld_large_biomes/continents");
    private static final ResourceKey<DensityFunction> EROSION_LARGE = TropicraftNoiseGen.createKey("overworld_large_biomes/erosion");
    private static final ResourceKey<DensityFunction> FACTOR_LARGE = TropicraftNoiseGen.createKey("overworld_large_biomes/factor");
    private static final ResourceKey<DensityFunction> DEPTH_LARGE = TropicraftNoiseGen.createKey("overworld_large_biomes/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE_LARGE = TropicraftNoiseGen.createKey("overworld_large_biomes/sloped_cheese");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE_END = TropicraftNoiseGen.createKey("end/sloped_cheese");
    private static final ResourceKey<DensityFunction> SPAGHETTI_ROUGHNESS_FUNCTION = TropicraftNoiseGen.createKey("overworld/caves/spaghetti_roughness_function");
    private static final ResourceKey<DensityFunction> ENTRANCES = TropicraftNoiseGen.createKey("overworld/caves/entrances");
    private static final ResourceKey<DensityFunction> NOODLE = TropicraftNoiseGen.createKey("overworld/caves/noodle");
    private static final ResourceKey<DensityFunction> PILLARS = TropicraftNoiseGen.createKey("overworld/caves/pillars");
    private static final ResourceKey<DensityFunction> SPAGHETTI_2D_THICKNESS_MODULATOR = TropicraftNoiseGen.createKey("overworld/caves/spaghetti_2d_thickness_modulator");
    private static final ResourceKey<DensityFunction> SPAGHETTI_2D = TropicraftNoiseGen.createKey("overworld/caves/spaghetti_2d");

    public static NoiseRouterWithOnlyNoises tropics(NoiseSettings settings) {
        DensityFunction aquiferBarrier = DensityFunctions.m_208324_(TropicraftNoiseGen.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189287_), (double)0.5);
        DensityFunction aquiferFluidLevelFloodedness = DensityFunctions.m_208324_(TropicraftNoiseGen.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189288_), (double)0.67);
        DensityFunction aquiferFluidLevelSpread = DensityFunctions.m_208324_(TropicraftNoiseGen.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189290_), (double)0.7142857142857143);
        DensityFunction aquiferLava = DensityFunctions.m_208322_(TropicraftNoiseGen.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189289_));
        DensityFunction shiftX = TropicraftNoiseGen.getFunction(SHIFT_X);
        DensityFunction shiftZ = TropicraftNoiseGen.getFunction(SHIFT_Z);
        DensityFunction temperature = DensityFunctions.m_208296_((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, TropicraftNoiseGen.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189269_));
        DensityFunction vegetation = DensityFunctions.m_208296_((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, TropicraftNoiseGen.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189278_));
        DensityFunction factor = TropicraftNoiseGen.getFunction(FACTOR);
        DensityFunction depth = TropicraftNoiseGen.getFunction(DEPTH);
        DensityFunction initialDensityWithoutJaggedness = TropicraftNoiseGen.noiseGradientDensity(DensityFunctions.m_208373_((DensityFunction)factor), depth);
        DensityFunction slopedCheese = TropicraftNoiseGen.getFunction(SLOPED_CHEESE);
        DensityFunction densityfunction12 = DensityFunctions.m_208375_((DensityFunction)slopedCheese, (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)5.0), (DensityFunction)TropicraftNoiseGen.getFunction(ENTRANCES)));
        DensityFunction densityfunction13 = DensityFunctions.m_208287_((DensityFunction)slopedCheese, (double)-1000000.0, (double)1.5625, (DensityFunction)densityfunction12, (DensityFunction)TropicraftNoiseGen.underground(slopedCheese));
        DensityFunction finalDensity = DensityFunctions.m_208375_((DensityFunction)TropicraftNoiseGen.postProcess(settings, densityfunction13), (DensityFunction)TropicraftNoiseGen.getFunction(NOODLE));
        DensityFunction y = TropicraftNoiseGen.getFunction(Y);
        int j = -60;
        int k = 50;
        DensityFunction veinToggle = TropicraftNoiseGen.yLimitedInterpolatable(y, DensityFunctions.m_208368_(TropicraftNoiseGen.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189247_), (double)1.5, (double)1.5), j, k, 0);
        DensityFunction oreVeinA = TropicraftNoiseGen.yLimitedInterpolatable(y, DensityFunctions.m_208368_(TropicraftNoiseGen.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189248_), (double)4.0, (double)4.0), j, k, 0).m_208229_();
        DensityFunction oreVeinB = TropicraftNoiseGen.yLimitedInterpolatable(y, DensityFunctions.m_208368_(TropicraftNoiseGen.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189249_), (double)4.0, (double)4.0), j, k, 0).m_208229_();
        DensityFunction veinRidged = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.08f), (DensityFunction)DensityFunctions.m_208382_((DensityFunction)oreVeinA, (DensityFunction)oreVeinB));
        DensityFunction veinGap = DensityFunctions.m_208322_(TropicraftNoiseGen.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189250_));
        return new NoiseRouterWithOnlyNoises(aquiferBarrier, aquiferFluidLevelFloodedness, aquiferFluidLevelSpread, aquiferLava, temperature, vegetation, TropicraftNoiseGen.getFunction(CONTINENTS), TropicraftNoiseGen.getFunction(EROSION), depth, TropicraftNoiseGen.getFunction(RIDGES), initialDensityWithoutJaggedness, finalDensity, veinToggle, veinRidged, veinGap);
    }

    private static DensityFunction postProcess(NoiseSettings settings, DensityFunction function) {
        DensityFunction slide = DensityFunctions.m_208319_((NoiseSettings)settings, (DensityFunction)function);
        DensityFunction blend = DensityFunctions.m_208389_((DensityFunction)slide);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208281_((DensityFunction)blend), (DensityFunction)DensityFunctions.m_208264_((double)0.64)).m_208234_();
    }

    private static Holder<NormalNoise.NoiseParameters> getNoise(ResourceKey<NormalNoise.NoiseParameters> p_209543_) {
        return BuiltinRegistries.f_194654_.m_206081_(p_209543_);
    }

    private static ResourceKey<DensityFunction> createKey(String p_209537_) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_211074_, (ResourceLocation)new ResourceLocation(p_209537_));
    }

    private static DensityFunction getFunction(ResourceKey<DensityFunction> key) {
        return new DensityFunctions.HolderHolder(BuiltinRegistries.f_211085_.m_206081_(key));
    }

    private static DensityFunction yLimitedInterpolatable(DensityFunction p_209472_, DensityFunction p_209473_, int p_209474_, int p_209475_, int p_209476_) {
        return DensityFunctions.m_208281_((DensityFunction)DensityFunctions.m_208287_((DensityFunction)p_209472_, (double)p_209474_, (double)(p_209475_ + 1), (DensityFunction)p_209473_, (DensityFunction)DensityFunctions.m_208264_((double)p_209476_)));
    }

    private static DensityFunction noiseGradientDensity(DensityFunction p_212272_, DensityFunction p_212273_) {
        DensityFunction densityfunction = DensityFunctions.m_208363_((DensityFunction)p_212273_, (DensityFunction)p_212272_);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)4.0), (DensityFunction)densityfunction.m_208233_());
    }

    private static DensityFunction underground(DensityFunction p_209470_) {
        DensityFunction densityfunction = TropicraftNoiseGen.getFunction(SPAGHETTI_2D);
        DensityFunction densityfunction1 = TropicraftNoiseGen.getFunction(SPAGHETTI_ROUGHNESS_FUNCTION);
        DensityFunction densityfunction2 = DensityFunctions.m_208324_(TropicraftNoiseGen.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189245_), (double)8.0);
        DensityFunction densityfunction3 = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)4.0), (DensityFunction)densityfunction2.m_208230_());
        DensityFunction densityfunction4 = DensityFunctions.m_208324_(TropicraftNoiseGen.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189246_), (double)0.6666666666666666);
        DensityFunction densityfunction5 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)0.27), (DensityFunction)densityfunction4).m_208220_(-1.0, 1.0), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)1.5), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)-0.64), (DensityFunction)p_209470_)).m_208220_(0.0, 0.5));
        DensityFunction densityfunction6 = DensityFunctions.m_208293_((DensityFunction)densityfunction3, (DensityFunction)densityfunction5);
        DensityFunction densityfunction7 = DensityFunctions.m_208375_((DensityFunction)DensityFunctions.m_208375_((DensityFunction)densityfunction6, (DensityFunction)TropicraftNoiseGen.getFunction(ENTRANCES)), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)densityfunction, (DensityFunction)densityfunction1));
        DensityFunction densityfunction8 = TropicraftNoiseGen.getFunction(PILLARS);
        DensityFunction densityfunction9 = DensityFunctions.m_208287_((DensityFunction)densityfunction8, (double)-1000000.0, (double)0.03, (DensityFunction)DensityFunctions.m_208264_((double)-1000000.0), (DensityFunction)densityfunction8);
        return DensityFunctions.m_208382_((DensityFunction)densityfunction7, (DensityFunction)densityfunction9);
    }
}

