/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class EntityAIAvoidEntityOnLowHealth<T extends Entity>
extends Goal {
    private final Predicate<Entity> canBeSeenSelector = entity -> entity.m_6084_() && this.theEntity.m_21574_().m_148306_(entity);
    protected PathfinderMob theEntity;
    private final double farSpeed;
    private final double nearSpeed;
    protected T closestLivingEntity;
    private final float avoidDistance;
    private Path entityPathEntity;
    private final PathNavigation entityPathNavigate;
    private final Class<T> classToAvoid;
    private final Predicate<Entity> avoidTargetSelector;
    private float healthToAvoid = 0.0f;

    public EntityAIAvoidEntityOnLowHealth(PathfinderMob theEntityIn, Class<T> classToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn, float healthToAvoid) {
        this(theEntityIn, classToAvoidIn, entity -> true, avoidDistanceIn, farSpeedIn, nearSpeedIn, healthToAvoid);
    }

    public EntityAIAvoidEntityOnLowHealth(PathfinderMob theEntityIn, Class<T> classToAvoidIn, Predicate<Entity> avoidTargetSelectorIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn, float healthToAvoid) {
        this.theEntity = theEntityIn;
        this.classToAvoid = classToAvoidIn;
        this.avoidTargetSelector = avoidTargetSelectorIn;
        this.avoidDistance = avoidDistanceIn;
        this.farSpeed = farSpeedIn;
        this.nearSpeed = nearSpeedIn;
        this.entityPathNavigate = theEntityIn.m_21573_();
        this.healthToAvoid = healthToAvoid;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.theEntity.m_21223_() > this.healthToAvoid) {
            return false;
        }
        List list = this.theEntity.f_19853_.m_6443_(this.classToAvoid, this.theEntity.m_142469_().m_82363_((double)this.avoidDistance, 3.0, (double)this.avoidDistance), EntitySelector.f_20406_.and(this.canBeSeenSelector).and(this.avoidTargetSelector));
        if (list.isEmpty()) {
            return false;
        }
        this.closestLivingEntity = (Entity)list.get(0);
        Vec3 Vector3d = DefaultRandomPos.m_148407_((PathfinderMob)this.theEntity, (int)16, (int)7, (Vec3)new Vec3(this.closestLivingEntity.m_20185_(), this.closestLivingEntity.m_20186_(), this.closestLivingEntity.m_20189_()));
        if (Vector3d == null) {
            return false;
        }
        if (this.closestLivingEntity.m_20275_(Vector3d.f_82479_, Vector3d.f_82480_, Vector3d.f_82481_) < this.closestLivingEntity.m_20280_((Entity)this.theEntity)) {
            return false;
        }
        this.entityPathEntity = this.entityPathNavigate.m_26524_(Vector3d.f_82479_, Vector3d.f_82480_, Vector3d.f_82481_, 0);
        return this.entityPathEntity != null;
    }

    public boolean m_8045_() {
        return this.entityPathNavigate.m_26572_();
    }

    public void m_8056_() {
        this.entityPathNavigate.m_26536_(this.entityPathEntity, this.farSpeed);
    }

    public void m_8041_() {
        this.closestLivingEntity = null;
    }

    public void m_8037_() {
        if (this.theEntity.m_20280_(this.closestLivingEntity) < 49.0) {
            this.theEntity.m_21573_().m_26517_(this.nearSpeed);
        } else {
            this.theEntity.m_21573_().m_26517_(this.farSpeed);
        }
    }
}

