/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;

public class EntityAITemptHelmet
extends Goal {
    private final PathfinderMob temptedEntity;
    private final double speed;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double pitch;
    private double yaw;
    private Player temptingPlayer;
    private int delayTemptCounter;
    private boolean isRunning;
    private final Set<ItemEntry<? extends Item>> temptItem;
    private final boolean scaredByPlayerMovement;

    public EntityAITemptHelmet(PathfinderMob temptedEntityIn, double speedIn, ItemEntry<? extends Item> temptItemIn, boolean scaredByPlayerMovementIn) {
        this(temptedEntityIn, speedIn, scaredByPlayerMovementIn, Set.of(temptItemIn));
    }

    public EntityAITemptHelmet(PathfinderMob temptedEntityIn, double speedIn, boolean scaredByPlayerMovementIn, Set<ItemEntry<? extends Item>> temptItemIn) {
        this.temptedEntity = temptedEntityIn;
        this.speed = speedIn;
        this.temptItem = temptItemIn;
        this.scaredByPlayerMovement = scaredByPlayerMovementIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(temptedEntityIn.m_21573_() instanceof GroundPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
        }
    }

    public boolean m_8036_() {
        if (this.temptedEntity instanceof EntityKoaBase && ((EntityKoaBase)this.temptedEntity).druggedTime <= 0) {
            return false;
        }
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingPlayer = this.temptedEntity.f_19853_.m_45930_((Entity)this.temptedEntity, 10.0);
        if (this.temptingPlayer == null) {
            return false;
        }
        return this.isTempting((ItemStack)this.temptingPlayer.m_150109_().f_35975_.get(3));
    }

    protected boolean isTempting(ItemStack stack) {
        for (ItemEntry<? extends Item> items : this.temptItem) {
            if (!items.isPresent() || ((Item)items.get()).m_5456_() != stack.m_41720_()) continue;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.scaredByPlayerMovement) {
            if (this.temptedEntity.m_20280_((Entity)this.temptingPlayer) < 36.0) {
                if (this.temptingPlayer.m_20275_(this.targetX, this.targetY, this.targetZ) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.temptingPlayer.m_146909_() - this.pitch) > 5.0 || Math.abs((double)this.temptingPlayer.m_146908_() - this.yaw) > 5.0) {
                    return false;
                }
            } else {
                this.targetX = this.temptingPlayer.m_20185_();
                this.targetY = this.temptingPlayer.m_20186_();
                this.targetZ = this.temptingPlayer.m_20189_();
            }
            this.pitch = this.temptingPlayer.m_146909_();
            this.yaw = this.temptingPlayer.m_146908_();
        }
        return this.m_8036_();
    }

    public void m_8056_() {
        this.targetX = this.temptingPlayer.m_20185_();
        this.targetY = this.temptingPlayer.m_20186_();
        this.targetZ = this.temptingPlayer.m_20189_();
        this.isRunning = true;
    }

    public void m_8041_() {
        this.temptingPlayer = null;
        this.temptedEntity.m_21573_().m_26573_();
        this.delayTemptCounter = 100;
        this.isRunning = false;
    }

    public void m_8037_() {
        this.temptedEntity.m_21563_().m_24960_((Entity)this.temptingPlayer, (float)(this.temptedEntity.m_8085_() + 20), (float)this.temptedEntity.m_8132_());
        if (this.temptedEntity.m_20280_((Entity)this.temptingPlayer) < 6.25) {
            this.temptedEntity.m_21573_().m_26573_();
        } else {
            this.temptedEntity.m_21573_().m_5624_((Entity)this.temptingPlayer, this.speed);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

