/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.item.TropicraftItems;

public class FailgullEntity
extends Animal
implements FlyingAnimal {
    private boolean isFlockLeader;
    private static final EntityDataAccessor<Optional<UUID>> FLOCK_LEADER_UUID = SynchedEntityData.m_135353_(FailgullEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public FailgullEntity(EntityType<? extends FailgullEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 1;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 5, true);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.6).m_22268_(Attributes.f_22280_, 0.9).m_22268_(Attributes.f_22277_, 12.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLOCK_LEADER_UUID, Optional.empty());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.isFlockLeader = nbt.m_128471_("IsFlockLeader");
        if (nbt.m_128441_("FlockLeader")) {
            this.setFlockLeader(Optional.of(nbt.m_128342_("FlockLeader")));
        } else {
            this.setFlockLeader(Optional.empty());
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("IsFlockLeader", this.isFlockLeader);
        ((Optional)this.f_19804_.m_135370_(FLOCK_LEADER_UUID)).ifPresent(uuid -> nbt.m_128362_("FlockLeader", uuid));
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return worldIn.m_8055_(pos).m_60795_() ? 10.0f : 0.0f;
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new ValidateFlockLeader(this));
        this.f_21345_.m_25352_(1, (Goal)new SelectFlockLeader(this));
        this.f_21345_.m_25352_(2, (Goal)new SetTravelDestination());
        this.f_21345_.m_25352_(2, (Goal)new FollowLeaderGoal());
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.5f;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn){

            public boolean m_6342_(BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(false);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    private void poop() {
        if (!this.f_19853_.f_46443_ && this.f_19853_.f_46441_.nextInt(20) == 0) {
            Snowball s = new Snowball(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            s.m_6686_(0.0, 0.0, 0.0, 0.0f, 0.0f);
            this.f_19853_.m_7967_((Entity)s);
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return null;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob partner) {
        return null;
    }

    private void setIsFlockLeader(boolean isFlockLeader) {
        this.isFlockLeader = isFlockLeader;
    }

    private void setFlockLeader(Optional<UUID> flockLeaderUUID) {
        this.f_19804_.m_135381_(FLOCK_LEADER_UUID, flockLeaderUUID);
    }

    private boolean getIsFlockLeader() {
        return this.isFlockLeader;
    }

    private boolean hasFlockLeader() {
        return ((Optional)this.f_19804_.m_135370_(FLOCK_LEADER_UUID)).isPresent();
    }

    @Nullable
    private Entity getFlockLeader() {
        if (this.f_19853_ instanceof ServerLevel && this.hasFlockLeader()) {
            return ((ServerLevel)this.f_19853_).m_8791_((UUID)((Optional)this.f_19804_.m_135370_(FLOCK_LEADER_UUID)).get());
        }
        return null;
    }

    @Nullable
    private BlockPos getRandomLocation() {
        Random random = this.m_21187_();
        for (int i = 0; i < 20; ++i) {
            double nextZPos;
            double nextYPos;
            double nextXPos = this.m_20185_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 48.0f);
            BlockPos pos = new BlockPos(nextXPos, nextYPos = this.m_20186_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 3.0f), nextZPos = this.m_20189_() + (double)((random.nextFloat() * 2.0f - 1.0f) * 48.0f));
            if (!this.f_19853_.m_46859_(pos)) continue;
            return pos;
        }
        Vec3 direction = this.m_20252_(0.0f);
        float maxAngle = 1.5707964f;
        Vec3 target = HoverRandomPos.m_148465_((PathfinderMob)this, (int)40, (int)3, (double)direction.f_82479_, (double)direction.f_82481_, (float)1.5707964f, (int)2, (int)1);
        Vec3 groundPos = AirAndWaterRandomPos.m_148357_((PathfinderMob)this, (int)40, (int)4, (int)-2, (double)direction.f_82479_, (double)direction.f_82481_, (double)1.5707963705062866);
        return target != null ? new BlockPos(target) : (groundPos != null ? new BlockPos(groundPos) : null);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.FAILGULL_SPAWN_EGG.get());
    }

    public boolean m_142592_() {
        return !this.f_19861_;
    }

    private static class ValidateFlockLeader
    extends Goal {
        final FailgullEntity mob;

        public ValidateFlockLeader(FailgullEntity failgullEntity) {
            this.mob = failgullEntity;
        }

        public boolean m_8036_() {
            if (this.mob.getIsFlockLeader()) {
                return false;
            }
            Entity flockLeader = this.mob.getFlockLeader();
            return flockLeader == null || !flockLeader.m_6084_();
        }

        public void m_8056_() {
            this.mob.setFlockLeader(Optional.empty());
        }
    }

    private static class SelectFlockLeader
    extends Goal {
        final FailgullEntity mob;

        public SelectFlockLeader(FailgullEntity failgullEntity) {
            this.mob = failgullEntity;
        }

        public boolean m_8036_() {
            return !this.mob.hasFlockLeader();
        }

        public void m_8056_() {
            List list = this.mob.f_19853_.m_45976_(FailgullEntity.class, this.mob.m_142469_().m_82377_(10.0, 10.0, 10.0));
            list.remove((Object)this.mob);
            Optional<FailgullEntity> oldest = list.stream().min(Comparator.comparingInt(Entity::m_142049_));
            if (oldest.isPresent() && !oldest.get().f_19820_.equals(this.mob.m_142081_())) {
                FailgullEntity oldestFailgull = oldest.get();
                oldestFailgull.setIsFlockLeader(true);
                oldestFailgull.setFlockLeader(Optional.empty());
                this.mob.setIsFlockLeader(false);
                this.mob.setFlockLeader(Optional.of(oldestFailgull.m_142081_()));
            }
        }
    }

    class SetTravelDestination
    extends Goal {
        SetTravelDestination() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        private boolean shouldLead() {
            return FailgullEntity.this.getIsFlockLeader() || !FailgullEntity.this.hasFlockLeader();
        }

        public boolean m_8036_() {
            return this.shouldLead() && FailgullEntity.this.m_21573_().m_26571_() && FailgullEntity.this.m_21187_().nextInt(10) == 0;
        }

        public boolean m_8045_() {
            return this.shouldLead() && FailgullEntity.this.m_21573_().m_26572_();
        }

        public void m_8056_() {
            BlockPos Vector3d = FailgullEntity.this.getRandomLocation();
            if (Vector3d != null) {
                PathNavigation navigator = FailgullEntity.this.m_21573_();
                navigator.m_26536_(navigator.m_7864_(Vector3d, 1), 1.0);
            }
        }
    }

    class FollowLeaderGoal
    extends Goal {
        FollowLeaderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        private boolean canFollow() {
            return !FailgullEntity.this.getIsFlockLeader() && FailgullEntity.this.hasFlockLeader();
        }

        public boolean m_8036_() {
            return this.canFollow() && FailgullEntity.this.m_21573_().m_26571_() && FailgullEntity.this.f_19796_.nextInt(10) == 0;
        }

        public boolean m_8045_() {
            return this.canFollow() && FailgullEntity.this.m_21573_().m_26572_();
        }

        public void m_8056_() {
            Entity flockLeader = FailgullEntity.this.getFlockLeader();
            PathNavigation navigator = FailgullEntity.this.m_21573_();
            if (flockLeader != null && flockLeader.m_6095_() == TropicraftEntities.FAILGULL.get()) {
                navigator.m_26536_(navigator.m_7864_(flockLeader.m_142538_(), 1), 1.0);
                return;
            }
            BlockPos Vector3d = FailgullEntity.this.getRandomLocation();
            if (Vector3d != null) {
                navigator.m_26536_(navigator.m_7864_(Vector3d, 1), 1.0);
            }
        }
    }
}

