/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.placeable;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class BeachFloatEntity
extends FurnitureEntity
implements IEntityAdditionalSpawnData {
    @Nonnull
    private static final Random rand = new Random(298457L);
    @Nonnull
    private static final PerlinSimplexNoise windNoise = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(298457L)), (List)ImmutableList.of((Object)0));
    private double windModifier = 0.0;
    public boolean isEmpty = true;
    public float rotationSpeed;
    private double prevMotionY;

    public BeachFloatEntity(EntityType<BeachFloatEntity> type, Level worldIn) {
        super(type, worldIn, TropicraftItems.BEACH_FLOATS);
        this.f_19850_ = true;
        this.m_20234_(this.m_142049_());
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        rand.setSeed(id);
        this.windModifier = 1.0 + rand.nextGaussian() * 0.1 - 0.05;
    }

    @Override
    public void m_8119_() {
        double eps;
        double center;
        double water;
        Entity rider = this.m_6688_();
        if (this.f_19853_.f_46443_ && rider instanceof Player) {
            Player controller = (Player)rider;
            float move = controller.f_20902_;
            float rot = -controller.f_20900_;
            this.rotationSpeed += rot * 0.25f;
            float ang = this.m_146908_();
            float moveX = Mth.m_14031_((float)(-ang * ((float)Math.PI / 180))) * move * 0.0035f;
            float moveZ = Mth.m_14089_((float)(ang * ((float)Math.PI / 180))) * move * 0.0035f;
            this.m_20256_(this.m_20184_().m_82520_((double)moveX, 0.0, (double)moveZ));
        }
        if (this.f_19798_) {
            double windAng = (windNoise.m_75449_(this.m_20185_() / 1000.0, this.m_20189_() / 1000.0, false) + 1.0) * Math.PI;
            double windX = Math.sin(windAng) * 5.0E-4 * this.windModifier;
            double windZ = Math.cos(windAng) * 5.0E-4 * this.windModifier;
            this.m_20256_(this.m_20184_().m_82520_(windX, 0.0, windZ));
            double targetYaw = Math.toDegrees(windAng) + (this.windModifier - 1.0) * 45.0;
            double yaw = (Mth.m_14177_((float)this.m_146908_()) + 180.0f - 35.0f) % 360.0f;
            double angleDiff = targetYaw - yaw;
            this.rotationSpeed = angleDiff > 0.0 ? (float)((double)this.rotationSpeed + Math.min(0.005 * this.windModifier, angleDiff)) : (float)((double)this.rotationSpeed + Math.max(-0.005 * this.windModifier, angleDiff));
        }
        if ((water = (double)this.getWaterLevel()) < (center = this.getCenterY()) - (eps = 0.0625)) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -Mth.m_14008_((double)(center - water), (double)0.0, (double)0.04), 0.0));
        } else if (water > center + eps) {
            double floatpush = Mth.m_14008_((double)(water - center), (double)0.0, (double)0.02);
            this.m_20256_(this.m_20184_().m_82520_(0.0, floatpush, 0.0));
        } else if (Math.abs(this.m_20184_().f_82480_) < 0.02) {
            if (this.m_20184_().f_82480_ != 0.0) {
                this.lerpY = water - 0.011;
            }
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            this.prevMotionY = 0.0;
        }
        super.m_8119_();
        this.m_146922_(this.m_146908_() + this.rotationSpeed);
        this.m_6478_(MoverType.PLAYER, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82542_(0.9, 0.9, 0.9));
        this.rotationSpeed *= 0.9f;
        if (!this.f_19853_.f_46443_) {
            List list = this.f_19853_.m_45933_((Entity)this, this.m_142469_().m_82377_((double)0.2f, 0.0, (double)0.2f));
            for (Entity entity : list) {
                if (entity == this.m_6688_() || !entity.m_6094_()) continue;
                entity.m_7334_((Entity)this);
            }
            if (this.m_6688_() != null && !this.m_6688_().m_6084_()) {
                this.m_20153_();
            }
        }
    }

    @Override
    protected boolean preventMotion() {
        return false;
    }

    private double getCenterY() {
        AABB bb = this.m_142469_();
        return bb.f_82289_ + (bb.f_82292_ - bb.f_82289_) * 0.5;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.prevMotionY = this.m_20184_().f_82480_;
        super.m_7840_(y, onGroundIn, state, pos);
    }

    protected boolean m_20073_() {
        this.f_19799_.clear();
        this.updateWaterState();
        boolean lava = this.m_204031_(FluidTags.f_13132_, this.f_19853_.m_6042_().m_63951_() ? 0.007 : 0.0023333333333333335);
        return this.m_20069_() || lava;
    }

    void updateWaterState() {
        AABB temp = this.m_142469_();
        this.m_20011_(temp.m_82310_(1.0, 0.0, 1.0).m_82310_(-1.0, 0.125, -1.0));
        try {
            if (this.m_204031_(FluidTags.f_13131_, 0.014)) {
                if (!this.f_19798_ && !this.f_19803_) {
                    this.m_5841_();
                }
                this.f_19789_ = 0.0f;
                this.f_19798_ = true;
                this.m_20095_();
            } else {
                this.f_19798_ = false;
            }
        }
        finally {
            this.m_20011_(temp);
        }
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.invulnerablityCheck(player, hand) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (!this.f_19853_.f_46443_ && !player.m_6144_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return !player.m_20365_((Entity)this) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public void m_7332_(@Nonnull Entity passenger) {
        if (this.m_20363_(passenger)) {
            float f = 0.0f;
            float f1 = (float)((!this.m_6084_() ? 0.001 : this.m_6048_()) + passenger.m_6049_());
            if (this.m_20197_().size() > 1) {
                int i = this.m_20197_().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof LivingEntity) {
                    f = (float)((double)f + 0.2);
                }
            }
            float len = 0.6f;
            double x = this.m_20185_() + (double)(-Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * len);
            double z = this.m_20189_() + (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * len);
            passenger.m_6034_(x, this.m_20186_() + (double)f1, z);
            passenger.m_146922_(passenger.m_146908_() + this.rotationSpeed);
            passenger.m_5616_(passenger.m_6080_() + this.rotationSpeed);
            this.applyYawToEntity(passenger);
            if (passenger instanceof LivingEntity && this.m_20197_().size() > 1) {
                int j = passenger.m_142049_() % 2 == 0 ? 90 : 270;
                passenger.m_5618_(((LivingEntity)passenger).f_20883_ + (float)j);
                passenger.m_5616_(passenger.m_6080_() + (float)j);
            }
            if (passenger instanceof Player) {
                ((Player)passenger).m_20011_(this.m_142469_().m_82363_(0.0, 0.3, 0.0).m_82310_(0.0, -0.1875, 0.0));
            }
        }
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (passenger instanceof Player) {
            passenger.m_6210_();
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        if (!entityToUpdate.f_19853_.f_46443_ || BeachFloatEntity.isClientFirstPerson(entityToUpdate)) {
            entityToUpdate.m_5618_(this.m_146908_());
            float yaw = Mth.m_14177_((float)(entityToUpdate.m_146908_() - this.m_146908_()));
            float pitch = Mth.m_14177_((float)(entityToUpdate.m_146909_() - this.m_146909_()));
            float clampedYaw = Mth.m_14036_((float)yaw, (float)-105.0f, (float)105.0f);
            float clampedPitch = Mth.m_14036_((float)pitch, (float)-100.0f, (float)0.0f);
            float yawClampDelta = clampedYaw - yaw;
            float pitchClampDelta = clampedPitch - pitch;
            entityToUpdate.f_19859_ += yawClampDelta;
            entityToUpdate.m_146922_(entityToUpdate.m_146908_() + yawClampDelta);
            entityToUpdate.f_19860_ += pitchClampDelta;
            entityToUpdate.m_146926_(entityToUpdate.m_146909_() + pitchClampDelta);
            entityToUpdate.m_5616_(entityToUpdate.m_146908_());
        }
    }

    public void m_7340_(@Nonnull Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    private static boolean isClientFirstPerson(Entity entity) {
        Minecraft client = Minecraft.m_91087_();
        return client.f_91075_ == entity && client.f_91066_.m_92176_() == CameraType.FIRST_PERSON;
    }

    private float getWaterLevel() {
        AABB axisalignedbb = this.m_142469_();
        int minX = Mth.m_14107_((double)axisalignedbb.f_82288_);
        int maxX = Mth.m_14165_((double)axisalignedbb.f_82291_);
        int minY = Mth.m_14107_((double)(axisalignedbb.f_82289_ - this.prevMotionY));
        int maxY = minY + 1;
        int minZ = Mth.m_14107_((double)axisalignedbb.f_82290_);
        int maxZ = Mth.m_14165_((double)axisalignedbb.f_82293_);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        float waterHeight = minY - 1;
        for (int y = maxY; y >= minY; --y) {
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    pos.m_122178_(x, y, z);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)pos);
                    if (fluidstate.m_76152_().m_6212_((Fluid)Fluids.f_76193_)) {
                        waterHeight = Math.max(waterHeight, (float)pos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)pos));
                    }
                    if (!(waterHeight >= (float)maxY)) continue;
                    return waterHeight;
                }
            }
        }
        return waterHeight;
    }

    @Override
    public boolean m_6094_() {
        return true;
    }

    public double m_6049_() {
        return 0.0;
    }

    @Override
    public double m_6048_() {
        return (double)this.m_20206_() - 1.1;
    }

    @Nullable
    public Entity m_6688_() {
        List list = this.m_20197_();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public Direction m_6374_() {
        return this.m_6350_().m_122427_();
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.lerpYaw);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.lerpYaw = Mth.m_14175_((double)additionalData.readDouble());
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.BEACH_FLOATS.get(DyeColor.m_41053_((int)this.getColor().m_41060_())).get());
    }

    public AABB m_6921_() {
        return this.m_142469_().m_82377_(0.1, 0.1, 0.1);
    }
}

