/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.placeable;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class ChairEntity
extends FurnitureEntity {
    private static final EntityDataAccessor<Byte> COMESAILAWAY = SynchedEntityData.m_135353_(ChairEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public boolean isChairEmpty = true;
    private double speedMultiplier = 0.1;
    private float rotationDelta = 0.0f;
    private static final float ROTATION_SPEED = 2.5f;
    private static final float FRICTION = 0.05f;

    public ChairEntity(EntityType<ChairEntity> type, Level world) {
        super(type, world, TropicraftItems.CHAIRS);
    }

    @Override
    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        double waterHeight = 0.0;
        if (this.getComeSailAway()) {
            waterHeight = this.findWaterHeight(waterHeight);
        }
        double speed = this.m_20184_().m_82553_();
        if (this.getComeSailAway() && speed > 0.2625) {
            double forwardX = Math.cos(this.m_146908_() * ((float)Math.PI / 180));
            double forwardZ = Math.sin(this.m_146908_() * ((float)Math.PI / 180));
            int i = 0;
            while ((double)i < 1.0 + speed * 60.0) {
                double particleZ;
                double particleX;
                double d5 = this.f_19796_.nextFloat() * 2.0f - 1.0f;
                double d6 = (double)(this.f_19796_.nextInt(2) * 2 - 1) * 0.7;
                if (this.f_19796_.nextBoolean()) {
                    particleX = this.m_20185_() - forwardX * d5 * 0.8 + forwardZ * d6;
                    particleZ = this.m_20189_() - forwardZ * d5 * 0.8 - forwardX * d6;
                } else {
                    particleX = this.m_20185_() + forwardX + forwardZ * d5 * 0.7;
                    particleZ = this.m_20189_() + forwardZ - forwardX * d5 * 0.7;
                }
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, particleX, this.m_20186_() - 0.125, particleZ, this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_);
                ++i;
            }
        }
        if (!this.f_19853_.f_46443_ || this.getComeSailAway()) {
            double newSpeed;
            if (waterHeight < 1.0) {
                double d2 = waterHeight * 2.0 - 1.0;
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.04 * d2, 0.0));
            } else {
                if (this.m_20184_().f_82480_ < 0.0) {
                    this.m_20256_(this.m_20184_().m_82542_(1.0, 0.5, 1.0));
                }
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.007, 0.0));
            }
            if (this.getComeSailAway() && (entity = this.m_6688_()) instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                float yRot = passenger.m_146908_() + -passenger.f_20900_ * 90.0f;
                double moveX = -Math.sin(yRot * ((float)Math.PI / 180)) * this.speedMultiplier * (double)passenger.f_20902_ * 0.05;
                double moveZ = Math.cos(yRot * ((float)Math.PI / 180)) * this.speedMultiplier * (double)passenger.f_20902_ * 0.05;
                this.m_20256_(this.m_20184_().m_82520_(moveX, 0.0, moveZ));
            }
            if ((newSpeed = this.m_20184_().m_82553_()) > 0.45) {
                double friction = 0.45 / newSpeed;
                this.m_20256_(this.m_20184_().m_82542_(friction, 1.0, friction));
                newSpeed = 0.45;
            }
            if (newSpeed > speed && this.speedMultiplier < 0.45) {
                this.speedMultiplier += (0.45 - this.speedMultiplier) / 45.0;
                if (this.speedMultiplier > 0.45) {
                    this.speedMultiplier = 0.45;
                }
            } else {
                this.speedMultiplier -= (this.speedMultiplier - 0.1) / 45.0;
                if (this.speedMultiplier < 0.1) {
                    this.speedMultiplier = 0.1;
                }
            }
            if (this.getComeSailAway()) {
                for (int i = 0; i < 4; ++i) {
                    int x = Mth.m_14107_((double)(this.m_20185_() + ((double)(i % 2) - 0.5) * 0.8));
                    int z = Mth.m_14107_((double)(this.m_20189_() + ((double)(i / 2) - 0.5) * 0.8));
                    for (int j1 = 0; j1 < 2; ++j1) {
                        int k = Mth.m_14107_((double)this.m_20186_()) + j1;
                        BlockPos pos = new BlockPos(x, k, z);
                        Block block = this.f_19853_.m_8055_(pos).m_60734_();
                        if (block == Blocks.f_50125_) {
                            this.f_19853_.m_46961_(pos, true);
                            this.f_19862_ = false;
                            continue;
                        }
                        if (block != Blocks.f_50196_) continue;
                        this.f_19853_.m_46961_(pos, true);
                        this.f_19862_ = false;
                    }
                }
            }
            if (this.f_19861_) {
                this.m_20256_(this.m_20184_().m_82542_(0.5, 1.0, 0.5));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.getComeSailAway()) {
                this.m_20256_(this.m_20184_().m_82542_(0.99, 0.95, 0.99));
            }
            this.m_146926_(0.0f);
            float targetYRot = this.m_146908_();
            double deltaX = this.f_19854_ - this.m_20185_();
            double deltaZ = this.f_19856_ - this.m_20189_();
            if (deltaX * deltaX + deltaZ * deltaZ > 0.001) {
                targetYRot = (float)(Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI);
            }
            double yRotStep = Mth.m_14175_((double)((double)targetYRot - (double)this.m_146908_()));
            yRotStep = Mth.m_14008_((double)yRotStep, (double)-20.0, (double)20.0);
            this.m_146922_((float)((double)this.m_146908_() + yRotStep));
            this.m_19915_(this.m_146908_(), this.m_146909_());
            if (!this.f_19853_.f_46443_) {
                List entities = this.f_19853_.m_45933_((Entity)this, this.m_142469_().m_82377_(0.2, 0.0, 0.2));
                for (Entity entity2 : entities) {
                    if (entity2 == this.m_6688_() || !entity2.m_6094_() || !(entity2 instanceof ChairEntity)) continue;
                    entity2.m_7334_((Entity)this);
                }
                if (this.m_6688_() != null && !this.m_6688_().m_6084_()) {
                    this.m_20153_();
                }
            }
        } else {
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        this.rotationDelta *= 0.05f;
        if (this.f_19853_.f_46443_ && (entity = this.m_6688_()) instanceof Player) {
            Player controller = (Player)entity;
            this.rotationDelta += -controller.f_20900_ * 2.5f;
            this.m_146922_(this.m_146908_() + this.rotationDelta);
        }
    }

    private double findWaterHeight(double waterHeight) {
        AABB bounds = this.m_142469_();
        int steps = 5;
        for (int i = 0; i < steps; ++i) {
            double end;
            double start = Mth.m_14139_((double)((double)i / (double)steps), (double)bounds.f_82289_, (double)bounds.f_82292_) - 0.125;
            AABB testBounds = new AABB(bounds.f_82288_, start, bounds.f_82290_, bounds.f_82291_, end = Mth.m_14139_((double)((double)(i + 1) / (double)steps), (double)bounds.f_82289_, (double)bounds.f_82292_) - 0.125, bounds.f_82293_);
            if (!this.f_19853_.m_46855_(testBounds)) continue;
            waterHeight += 1.0 / (double)steps;
        }
        return waterHeight;
    }

    @Override
    protected boolean preventMotion() {
        return !this.getComeSailAway();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(COMESAILAWAY, (Object)0);
    }

    @Override
    protected void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setComeSailAway(nbt.m_128471_("COME_SAIL_AWAY"));
    }

    @Override
    protected void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("COME_SAIL_AWAY", this.getComeSailAway());
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.invulnerablityCheck(player, hand) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (!this.f_19853_.f_46443_ && !player.m_6144_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return !player.m_20365_((Entity)this) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    public boolean m_6087_() {
        return this.m_6084_();
    }

    @Nullable
    public Entity m_6688_() {
        List list = this.m_20197_();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    @Override
    public double m_6048_() {
        return 0.11;
    }

    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            Vec3 xzOffset = new Vec3(0.0, 0.0, -0.125).m_82524_((float)Math.toRadians(-this.m_146908_()));
            passenger.m_6034_(this.m_20185_() + xzOffset.f_82479_, this.m_20186_() + this.m_6048_() + passenger.m_6049_(), this.m_20189_() + xzOffset.f_82481_);
            passenger.m_146922_(passenger.m_146908_() + this.rotationDelta);
            passenger.m_5618_(passenger.m_146908_() + this.rotationDelta);
        }
    }

    public void setComeSailAway(boolean sail) {
        this.f_19804_.m_135381_(COMESAILAWAY, (Object)(sail ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0)));
    }

    public boolean getComeSailAway() {
        return (Byte)this.f_19804_.m_135370_(COMESAILAWAY) == 1;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.CHAIRS.get(DyeColor.m_41053_((int)this.getColor().m_41060_())).get());
    }

    public AABB m_6921_() {
        return this.m_142469_().m_82363_(0.0, 1.0, 0.0);
    }
}

