/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.util.StringRepresentable;

public enum StarfishType implements StringRepresentable
{
    RED("starfishRed", "Red Starfish", new String[]{"starfish_red_0", "starfish_red_1", "starfish_red_2"}, new float[]{0.03125f, 0.015625f, 0.015625f}),
    ROYAL("starfishRoyal", "Royal Starfish", new String[]{"starfish_royal_0", "starfish_royal_1"});

    public static final StarfishType[] VALUES;
    private String unlocalizedName;
    private String displayName;
    private List<String> texturePaths;
    private float[] layerHeights;

    private StarfishType(String unlocalizedName, String displayName, String[] textures, float[] heights) {
        this.unlocalizedName = unlocalizedName;
        this.displayName = displayName;
        if (heights == null) {
            this.layerHeights = new float[textures.length];
            for (int i = 0; i < textures.length; ++i) {
                this.layerHeights[i] = 0.03125f;
            }
        } else {
            this.layerHeights = heights;
        }
        this.texturePaths = new ArrayList<String>(textures.length);
        Collections.addAll(this.texturePaths, textures);
    }

    private StarfishType(String unlocalizedName, String displayName, String[] textures) {
        this(unlocalizedName, displayName, textures, null);
    }

    public static byte getMetaFromType(StarfishType type) {
        return (byte)(type != RED ? 1 : 0);
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getTexturePaths() {
        return this.texturePaths;
    }

    public float[] getLayerHeights() {
        return this.layerHeights;
    }

    public int getLayerCount() {
        return this.texturePaths.size();
    }

    public static StarfishType getRandomType() {
        int type = new Random().nextInt(2);
        if (type == 0) {
            return RED;
        }
        return ROYAL;
    }

    public String m_7912_() {
        return this.unlocalizedName;
    }

    static {
        VALUES = StarfishType.values();
    }
}

