/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public abstract class TropicraftFishEntity
extends WaterAnimal {
    public float swimPitch = 0.0f;
    public float swimYaw = 0.0f;
    public Vec2 targetVectorHeading;
    public Vec3 targetVector;
    public int outOfWaterTime = 0;
    public float outOfWaterAngle = 0.0f;
    public float fallVelocity = 0.0f;
    public float fallGravity = 0.0625f;
    public float prevSwimPitch = 0.0f;
    public float prevSwimYaw = 0.0f;
    private float swimSpeedDefault = 1.0f;
    protected float swimSpeedCurrent = 0.0f;
    private float swimSpeedPanic = 2.0f;
    private float swimAccelRate = 0.02f;
    private float swimDecelRate = 0.02f;
    private float swimSpeedTurn = 5.0f;
    public boolean isMovingAwayFromWall = false;
    public boolean isPanicking = false;
    public boolean fleeFromPlayers = false;
    public boolean approachPlayers = false;
    public double fleeDistance = 2.0;
    public boolean isAggressing = false;
    public boolean canAggress = false;
    public int eatenFishAmount = 0;
    public int maximumEatAmount = 5;
    private float swimSpeedChasing = 2.0f;
    private float swimSpeedCharging = 2.5f;
    public Entity aggressTarget = null;
    private boolean fishable = false;

    protected TropicraftFishEntity(EntityType<? extends WaterAnimal> type, Level world) {
        super(type, world);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.m_146926_(-this.swimPitch);
            this.m_146922_(-this.swimYaw);
            this.f_20885_ = -this.swimYaw;
            this.f_20886_ = -this.prevSwimYaw;
            this.f_20883_ = 0.0f;
            this.f_19860_ = -this.prevSwimPitch;
            this.f_19859_ = -this.prevSwimYaw;
            double x = this.m_20185_() - this.f_19854_;
            double y = this.m_20186_() - this.f_19855_;
            double z = this.m_20189_() - this.f_19856_;
            this.prevSwimYaw = this.swimYaw;
            this.prevSwimPitch = this.swimPitch;
            float yaw = this.m_20185_() == this.f_19854_ && this.m_20189_() == this.f_19856_ ? this.swimYaw : (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
            float pitch = this.m_20186_() == this.f_19855_ ? this.swimPitch : (float)(-(Math.atan2(y, Mth.m_14116_((float)((float)(x * x + z * z)))) * 180.0 / Math.PI));
            this.swimYaw = this.lerp(this.swimYaw, (int)(-yaw), this.swimSpeedTurn * 4.0f);
            this.swimPitch = this.lerp(this.swimPitch, (int)(-pitch), this.swimSpeedTurn * 4.0f);
            this.m_20256_(this.m_20184_().m_82542_(0.98, 0.98, 0.98));
            if (this.m_21525_() && this.m_20069_()) {
                this.fallVelocity = 0.0f;
                this.swimSpeedCurrent = 0.0f;
                this.m_20256_(Vec3.f_82478_);
            }
        }
        if (this.m_20069_()) {
            if (this.isMovingAwayFromWall) {
                this.swimSpeedTurn *= 1.8f;
            }
            if (this.targetVectorHeading != null) {
                this.swimYaw = this.lerp(this.swimYaw, -this.targetVectorHeading.f_82470_, this.swimSpeedTurn);
                this.swimPitch = this.lerp(this.swimPitch, -this.targetVectorHeading.f_82471_, this.swimSpeedTurn);
            }
        }
        if (!this.m_20069_()) {
            this.setTargetHeading(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_(), false);
        }
        float currentSpeed = this.swimSpeedCurrent;
        float desiredSpeed = this.swimSpeedDefault;
        if (this.aggressTarget != null) {
            desiredSpeed = this.m_20280_(this.aggressTarget) < 10.0 ? this.swimSpeedCharging : this.swimSpeedChasing;
        }
        if (this.isPanicking) {
            desiredSpeed = this.swimSpeedPanic;
        }
        if (this.f_19797_ % 50 < 30) {
            desiredSpeed *= 0.8f;
        }
        if (this.isMovingAwayFromWall) {
            desiredSpeed *= 0.6f;
            currentSpeed *= 0.8f;
        }
        if (this.swimSpeedCurrent < desiredSpeed) {
            this.swimSpeedCurrent += this.swimAccelRate;
        }
        if (this.swimSpeedCurrent > desiredSpeed) {
            this.swimSpeedCurrent -= this.swimDecelRate;
        }
        currentSpeed *= 0.1f;
        if (this.m_20069_()) {
            this.m_20334_((double)currentSpeed * Math.sin((double)this.swimYaw * (Math.PI / 180)), (double)currentSpeed * Math.sin((double)this.swimPitch * (Math.PI / 180)), (double)currentSpeed * Math.cos((double)this.swimYaw * (Math.PI / 180)));
            this.fallVelocity = 0.0f;
        }
        if (this.m_21525_() && this.m_20069_()) {
            this.m_20334_(0.0, 0.0, 0.0);
            this.fallVelocity = 0.0f;
            this.swimSpeedCurrent = 0.0f;
        }
        if (this.swimPitch > 45.0f) {
            this.swimPitch = 45.0f;
        }
    }

    public float rangeMap(float input, float inpMin, float inpMax, float outMin, float outMax) {
        if ((double)Math.abs(inpMax - inpMin) < 1.0E-12) {
            return 0.0f;
        }
        double ratio = (outMax - outMin) / (inpMax - inpMin);
        return (float)(ratio * (double)(input - inpMin) + (double)outMin);
    }

    public void setSwimSpeeds(float regular, float panic, float turnSpeed) {
        this.swimSpeedDefault = regular;
        this.swimSpeedPanic = panic;
        this.swimSpeedTurn = turnSpeed;
    }

    public void setSwimSpeeds(float r, float p, float t, float chasing, float charging) {
        this.setSwimSpeeds(r, p, t);
        this.swimSpeedChasing = chasing;
        this.swimSpeedCharging = charging;
    }

    public void setApproachesPlayers(boolean b) {
        this.approachPlayers = b;
    }

    public float lerp(float x1, float x2, float t) {
        return x1 + t * 0.03f * Mth.m_14177_((float)(x2 - x1));
    }

    public boolean setTargetHeading(double posX, double posY, double posZ, boolean waterChecks) {
        BlockPos bp;
        BlockState stateAtPos;
        if (this.m_21525_()) {
            return false;
        }
        if (waterChecks && (!(stateAtPos = this.f_19853_.m_8055_(bp = new BlockPos((int)posX, (int)posY, (int)posZ))).m_60767_().m_76332_() || stateAtPos.m_60767_().m_76333_())) {
            return false;
        }
        double x = (int)(posX - this.m_20185_());
        double y = (int)(posY - this.m_20186_());
        double z = (int)(posZ - this.m_20189_());
        float yaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y, Mth.m_14116_((float)((float)(x * x + z * z)))) * 180.0 / Math.PI));
        this.targetVector = new Vec3((double)((int)posX), (double)((int)posY), (double)((int)posZ));
        this.targetVectorHeading = new Vec2(yaw, pitch);
        return true;
    }

    public Vec3 getHeading() {
        return new Vec3(Math.sin((double)this.swimYaw * (Math.PI / 180)), Math.sin((double)this.swimPitch * (Math.PI / 180)), Math.cos((double)this.swimYaw * (Math.PI / 180))).m_82541_();
    }

    public void setRandomTargetHeadingForce(int maxTimes) {
        for (int i = 0; i < maxTimes && !this.setRandomTargetHeading(); ++i) {
        }
    }

    public boolean setRandomTargetHeading() {
        Player closest;
        boolean result = false;
        int dist = 16;
        Vec3 randBlock = new Vec3(this.m_20185_() + (double)this.randFlip(dist), this.m_20186_() + (double)this.randFlip(dist / 2), this.m_20189_() + (double)this.randFlip(dist));
        result = this.setTargetHeading(randBlock.f_82479_, randBlock.f_82480_, randBlock.f_82481_, true);
        if (this.approachPlayers && this.f_19796_.nextInt(50) == 0 && (closest = this.f_19853_.m_45930_((Entity)this, 32.0)) != null && closest.m_20069_()) {
            result = this.setTargetHeading(closest.m_20185_(), closest.m_20186_(), closest.m_20189_(), true);
        }
        return result;
    }

    public void fleeEntity(Entity ent) {
        double x = ent.m_20185_() - this.m_20185_();
        double y = ent.m_20186_() - this.m_20186_();
        double z = ent.m_20189_() - this.m_20189_();
        float yaw = (float)(Math.atan2(z, x) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y, Mth.m_14116_((float)((float)(x * x + z * z)))) * 180.0 / Math.PI));
        if (this.targetVector == null) {
            this.targetVector = new Vec3(ent.m_20185_(), ent.m_20186_() - 5.0 + (double)this.f_19796_.nextInt(10), ent.m_20189_());
        }
        this.targetVectorHeading = new Vec2(yaw + 180.0f, -1.0f * pitch / 2.0f);
    }

    public int randFlip(int i) {
        return this.f_19796_.nextBoolean() ? this.f_19796_.nextInt(i) : -this.f_19796_.nextInt(i);
    }
}

